@extends('admin.layouts.app')

@section('title', 'Edit Product')

@section('content')
<form method="POST" action="{{ route('admin.products.update', $product) }}" enctype="multipart/form-data">
    @csrf
    @method('PUT')
    
    <div class="grid grid-2">
        <!-- Main Info -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Product Information</h3>
            </div>

            <div class="form-group">
                <label class="form-label">Product Name *</label>
                <input type="text" name="name" class="form-input" value="{{ old('name', $product->name) }}" required>
            </div>

            <div class="grid grid-2">
                <div class="form-group">
                    <label class="form-label">SKU *</label>
                    <input type="text" name="sku" class="form-input" value="{{ old('sku', $product->sku) }}" required>
                </div>
                <div class="form-group">
                    <label class="form-label">Category *</label>
                    <select name="category_id" class="form-select" required>
                        <option value="">Select Category</option>
                        @foreach($categories as $category)
                            <option value="{{ $category->id }}" {{ old('category_id', $product->category_id) == $category->id ? 'selected' : '' }}>
                                {{ $category->name }}
                            </option>
                            @foreach($category->children as $child)
                                <option value="{{ $child->id }}" {{ old('category_id', $product->category_id) == $child->id ? 'selected' : '' }}>
                                    &nbsp;&nbsp;└ {{ $child->name }}
                                </option>
                            @endforeach
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="form-group">
                <label class="form-label">Short Description</label>
                <textarea name="short_description" class="form-textarea" rows="2">{{ old('short_description', $product->short_description) }}</textarea>
            </div>

            <div class="form-group">
                <label class="form-label">Full Description</label>
                <textarea name="description" class="form-textarea" rows="5">{{ old('description', $product->description) }}</textarea>
            </div>
        </div>

        <!-- Pricing & Stock -->
        <div>
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Pricing & Stock</h3>
                </div>

                <div class="grid grid-2">
                    <div class="form-group">
                        <label class="form-label">Price (KSh) *</label>
                        <input type="number" name="price" class="form-input" value="{{ old('price', $product->price) }}" step="0.01" min="0" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label">Sale Price (KSh)</label>
                        <input type="number" name="sale_price" class="form-input" value="{{ old('sale_price', $product->sale_price) }}" step="0.01" min="0">
                    </div>
                </div>

                <div class="grid grid-2">
                    <div class="form-group">
                        <label class="form-label">Stock Quantity *</label>
                        <input type="number" name="stock_quantity" class="form-input" value="{{ old('stock_quantity', $product->stock_quantity) }}" min="0" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label">Weight (kg)</label>
                        <input type="number" name="weight" class="form-input" value="{{ old('weight', $product->weight) }}" step="0.01" min="0">
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Additional Info</h3>
                </div>

                <div class="grid grid-2">
                    <div class="form-group">
                        <label class="form-label">Brand</label>
                        <input type="text" name="brand" class="form-input" value="{{ old('brand', $product->brand) }}">
                    </div>
                    <div class="form-group">
                        <label class="form-label">Model</label>
                        <input type="text" name="model" class="form-input" value="{{ old('model', $product->model) }}">
                    </div>
                </div>

                <div class="form-group">
                    <label class="form-label">Warranty</label>
                    <input type="text" name="warranty" class="form-input" value="{{ old('warranty', $product->warranty) }}" placeholder="e.g., 1 year">
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Installation Service</h3>
                </div>

                <div class="form-group">
                    <label class="flex items-center gap-2">
                        <input type="checkbox" name="requires_installation" value="1" {{ old('requires_installation', $product->requires_installation) ? 'checked' : '' }}>
                        <span>This product requires/offers installation service</span>
                    </label>
                </div>

                <div class="form-group">
                    <label class="form-label">Installation Price (KSh)</label>
                    <input type="number" name="installation_price" class="form-input" value="{{ old('installation_price', $product->installation_price) }}" step="0.01" min="0">
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Status</h3>
                </div>

                <div class="form-group">
                    <label class="flex items-center gap-2">
                        <input type="checkbox" name="is_active" value="1" {{ old('is_active', $product->is_active) ? 'checked' : '' }}>
                        <span>Active (visible in shop)</span>
                    </label>
                </div>

                <div class="form-group mb-0">
                    <label class="flex items-center gap-2">
                        <input type="checkbox" name="is_featured" value="1" {{ old('is_featured', $product->is_featured) ? 'checked' : '' }}>
                        <span>Featured Product</span>
                    </label>
                </div>
            </div>
        </div>
    </div>

    <!-- Current Images -->
    @if($product->images->count() > 0)
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Current Images</h3>
        </div>

        <div class="flex gap-3" style="flex-wrap: wrap;">
            @foreach($product->images as $image)
            <div style="position: relative; width: 120px;">
                <img src="{{ asset('storage/' . $image->path) }}" alt="Product image" 
                     style="width: 120px; height: 120px; object-fit: cover; border-radius: 8px; border: 2px solid {{ $image->is_primary ? 'var(--primary)' : 'transparent' }};">
                
                <div class="flex gap-1 mt-1">
                    @if(!$image->is_primary)
                    <form method="POST" action="{{ route('admin.products.set-primary-image', $image) }}" style="flex: 1;">
                        @csrf
                        <button type="submit" class="btn btn-secondary btn-sm" style="width: 100%; font-size: 0.7rem;" title="Set as primary">
                            <i class="fas fa-star"></i>
                        </button>
                    </form>
                    @else
                    <span class="badge badge-primary" style="flex: 1; justify-content: center;">Primary</span>
                    @endif
                    
                    <form method="POST" action="{{ route('admin.products.delete-image', $image) }}" 
                          onsubmit="return confirm('Delete this image?')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-sm" style="font-size: 0.7rem;">
                            <i class="fas fa-trash"></i>
                        </button>
                    </form>
                </div>
            </div>
            @endforeach
        </div>
    </div>
    @endif

    <!-- Add More Images -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Add More Images</h3>
        </div>

        <div class="form-group mb-0">
            <input type="file" name="images[]" class="form-input" accept="image/*" multiple>
        </div>
    </div>

    <!-- Submit -->
    <div class="flex gap-3">
        <button type="submit" class="btn btn-primary">
            <i class="fas fa-save"></i> Update Product
        </button>
        <a href="{{ route('admin.products.index') }}" class="btn btn-secondary">Cancel</a>
    </div>
</form>
@endsection
