@extends('admin.layouts.app')

@section('title', 'Quotations')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title">All Quotations</h3>
        <a href="{{ route('admin.quotations.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> Create Quotation
        </a>
    </div>

    <!-- Filters -->
    <form method="GET" class="mb-3">
        <div class="flex gap-3 items-center">
            <input type="text" name="search" class="form-input" placeholder="Search quotations..." 
                   value="{{ request('search') }}" style="max-width: 300px;">
            
            <select name="status" class="form-select" style="max-width: 150px;">
                <option value="">All Status</option>
                <option value="draft" {{ request('status') == 'draft' ? 'selected' : '' }}>Draft</option>
                <option value="sent" {{ request('status') == 'sent' ? 'selected' : '' }}>Sent</option>
                <option value="accepted" {{ request('status') == 'accepted' ? 'selected' : '' }}>Accepted</option>
                <option value="rejected" {{ request('status') == 'rejected' ? 'selected' : '' }}>Rejected</option>
                <option value="expired" {{ request('status') == 'expired' ? 'selected' : '' }}>Expired</option>
            </select>

            <button type="submit" class="btn btn-primary">
                <i class="fas fa-search"></i> Filter
            </button>
            
            @if(request()->hasAny(['search', 'status']))
                <a href="{{ route('admin.quotations.index') }}" class="btn btn-secondary">Clear</a>
            @endif
        </div>
    </form>

    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th>Quotation #</th>
                    <th>Customer</th>
                    <th>Total</th>
                    <th>Discount</th>
                    <th>Status</th>
                    <th>Valid Until</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($quotations as $quotation)
                <tr>
                    <td>
                        <a href="{{ route('admin.quotations.show', $quotation) }}" class="text-primary">
                            <strong>{{ $quotation->quotation_number }}</strong>
                        </a>
                        @if($quotation->is_shop_customer)
                            <div class="badge badge-success" style="margin-top: 4px;">Shop Customer</div>
                        @endif
                    </td>
                    <td>
                        <div>
                            <strong>{{ $quotation->customer_name }}</strong>
                            <div class="text-muted" style="font-size: 0.8rem;">{{ $quotation->customer_email }}</div>
                        </div>
                    </td>
                    <td><strong>KSh {{ number_format($quotation->total, 2) }}</strong></td>
                    <td>
                        @if($quotation->installation_discount > 0)
                            <span class="text-success">- KSh {{ number_format($quotation->installation_discount, 2) }}</span>
                            <div class="text-muted" style="font-size: 0.75rem;">{{ $quotation->discount_percentage }}%</div>
                        @else
                            -
                        @endif
                    </td>
                    <td>
                        <span class="badge badge-{{ $quotation->status_badge['color'] }}">
                            {{ $quotation->status_badge['label'] }}
                        </span>
                    </td>
                    <td>
                        @if($quotation->valid_until)
                            <span class="{{ $quotation->is_expired ? 'text-danger' : '' }}">
                                {{ $quotation->valid_until->format('M d, Y') }}
                            </span>
                        @else
                            -
                        @endif
                    </td>
                    <td>
                        <div class="flex gap-2">
                            <a href="{{ route('admin.quotations.show', $quotation) }}" class="btn btn-secondary btn-sm">
                                <i class="fas fa-eye"></i>
                            </a>
                            <a href="{{ route('admin.quotations.pdf', $quotation) }}" class="btn btn-primary btn-sm">
                                <i class="fas fa-file-pdf"></i>
                            </a>
                            <form method="POST" action="{{ route('admin.quotations.destroy', $quotation) }}" 
                                  onsubmit="return confirm('Delete this quotation?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger btn-sm">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="7" class="text-muted" style="text-align: center; padding: 3rem;">
                        <i class="fas fa-file-invoice" style="font-size: 2rem; margin-bottom: 1rem; display: block;"></i>
                        No quotations yet. <a href="{{ route('admin.quotations.create') }}" class="text-primary">Create your first quotation</a>
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    {{ $quotations->links() }}
</div>
@endsection
