<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Quotation - {{ $quotation->quotation_number }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'DejaVu Sans', Arial, sans-serif;
            font-size: 12px;
            color: #333;
            line-height: 1.5;
        }
        .container {
            padding: 30px;
        }
        .header {
            display: table;
            width: 100%;
            margin-bottom: 30px;
            border-bottom: 3px solid #0ea5e9;
            padding-bottom: 20px;
        }
        .company-info {
            display: table-cell;
            width: 60%;
            vertical-align: top;
        }
        .company-name {
            font-size: 24px;
            font-weight: bold;
            color: #0ea5e9;
            margin-bottom: 5px;
        }
        .company-details {
            font-size: 11px;
            color: #666;
        }
        .quotation-title {
            display: table-cell;
            width: 40%;
            text-align: right;
            vertical-align: top;
        }
        .quotation-title h1 {
            font-size: 28px;
            color: #333;
            margin-bottom: 5px;
        }
        .quotation-number {
            font-size: 14px;
            color: #0ea5e9;
            font-weight: bold;
        }
        .info-section {
            display: table;
            width: 100%;
            margin-bottom: 25px;
        }
        .customer-info, .quotation-details {
            display: table-cell;
            width: 50%;
            vertical-align: top;
        }
        .info-box {
            background: #f8fafc;
            border: 1px solid #e2e8f0;
            border-radius: 5px;
            padding: 15px;
            margin-right: 10px;
        }
        .info-box h3 {
            font-size: 12px;
            color: #64748b;
            text-transform: uppercase;
            margin-bottom: 10px;
            border-bottom: 1px solid #e2e8f0;
            padding-bottom: 5px;
        }
        .info-box p {
            margin-bottom: 3px;
        }
        .info-box strong {
            color: #333;
        }
        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 25px;
        }
        .items-table th {
            background: #0ea5e9;
            color: white;
            padding: 12px 10px;
            text-align: left;
            font-size: 11px;
            text-transform: uppercase;
        }
        .items-table th:last-child,
        .items-table td:last-child {
            text-align: right;
        }
        .items-table td {
            padding: 12px 10px;
            border-bottom: 1px solid #e2e8f0;
        }
        .items-table tr:nth-child(even) {
            background: #f8fafc;
        }
        .item-type {
            display: inline-block;
            padding: 2px 8px;
            border-radius: 10px;
            font-size: 10px;
            text-transform: uppercase;
            font-weight: bold;
        }
        .item-type.product { background: #dbeafe; color: #1e40af; }
        .item-type.service { background: #dcfce7; color: #166534; }
        .item-type.labor { background: #fef3c7; color: #92400e; }
        .totals-section {
            display: table;
            width: 100%;
            margin-bottom: 25px;
        }
        .totals-left {
            display: table-cell;
            width: 60%;
            vertical-align: top;
        }
        .totals-right {
            display: table-cell;
            width: 40%;
            vertical-align: top;
        }
        .totals-box {
            background: #f8fafc;
            border: 1px solid #e2e8f0;
            border-radius: 5px;
            padding: 15px;
        }
        .totals-row {
            display: table;
            width: 100%;
            padding: 5px 0;
        }
        .totals-label {
            display: table-cell;
            width: 60%;
            color: #64748b;
        }
        .totals-value {
            display: table-cell;
            width: 40%;
            text-align: right;
            font-weight: 500;
        }
        .totals-row.total {
            border-top: 2px solid #0ea5e9;
            margin-top: 10px;
            padding-top: 10px;
        }
        .totals-row.total .totals-label,
        .totals-row.total .totals-value {
            font-size: 16px;
            font-weight: bold;
            color: #0ea5e9;
        }
        .discount-row {
            color: #22c55e;
        }
        .terms-section {
            margin-bottom: 25px;
        }
        .terms-section h3 {
            font-size: 12px;
            color: #64748b;
            text-transform: uppercase;
            margin-bottom: 10px;
        }
        .terms-box {
            background: #fef3c7;
            border: 1px solid #fcd34d;
            border-radius: 5px;
            padding: 15px;
            font-size: 11px;
        }
        .notes-section {
            margin-bottom: 25px;
        }
        .notes-box {
            background: #f8fafc;
            border: 1px solid #e2e8f0;
            border-radius: 5px;
            padding: 15px;
            font-size: 11px;
        }
        .footer {
            text-align: center;
            padding-top: 20px;
            border-top: 1px solid #e2e8f0;
            color: #64748b;
            font-size: 10px;
        }
        .validity {
            background: #dcfce7;
            border: 1px solid #22c55e;
            border-radius: 5px;
            padding: 10px;
            text-align: center;
            margin-bottom: 20px;
            color: #166534;
            font-weight: 500;
        }
        .status-badge {
            display: inline-block;
            padding: 5px 15px;
            border-radius: 15px;
            font-size: 11px;
            text-transform: uppercase;
            font-weight: bold;
        }
        .status-draft { background: #94a3b8; color: white; }
        .status-sent { background: #0ea5e9; color: white; }
        .status-accepted { background: #22c55e; color: white; }
        .status-rejected { background: #ef4444; color: white; }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <div class="company-info">
                <div class="company-name">{{ $company['company_name'] ?? 'OneSpot Solutions Ltd' }}</div>
                <div class="company-details">
                    {{ $company['company_address'] ?? 'Nairobi, Kenya' }}<br>
                    Phone: {{ $company['company_phone'] ?? '+254743456809' }}<br>
                    Email: {{ $company['company_email'] ?? 'info@onespotsolutionsltd.co.ke' }}
                </div>
            </div>
            <div class="quotation-title">
                <h1>QUOTATION</h1>
                <div class="quotation-number">{{ $quotation->quotation_number }}</div>
                <div style="margin-top: 10px;">
                    <span class="status-badge status-{{ $quotation->status }}">{{ $quotation->status === 'draft' ? 'OFFICIAL' : ucfirst($quotation->status) }}</span>
                </div>
            </div>
        </div>

        <!-- Validity Notice -->
        @if($quotation->valid_until)
        <div class="validity">
            This quotation is valid until: <strong>{{ $quotation->valid_until->format('F d, Y') }}</strong>
        </div>
        @endif

        <!-- Customer & Quotation Info -->
        <div class="info-section">
            <div class="customer-info">
                <div class="info-box">
                    <h3>Customer Information</h3>
                    <p><strong>{{ $quotation->customer_name }}</strong></p>
                    <p>{{ $quotation->customer_email }}</p>
                    <p>{{ $quotation->customer_phone }}</p>
                    @if($quotation->customer_address)
                    <p>{{ $quotation->customer_address }}</p>
                    @endif
                </div>
            </div>
            <div class="quotation-details">
                <div class="info-box" style="margin-right: 0; margin-left: 10px;">
                    <h3>Quotation Details</h3>
                    <p><strong>Date:</strong> {{ $quotation->created_at->format('F d, Y') }}</p>
                    <p><strong>Service Type:</strong> {{ ucfirst($quotation->service_type ?? 'General') }}</p>
                    @if($quotation->site_address)
                    <p><strong>Site Address:</strong> {{ $quotation->site_address }}</p>
                    @endif
                    @if($quotation->is_shop_customer)
                    <p style="color: #22c55e;"><strong>Shop Customer Discount Applied</strong></p>
                    @endif
                </div>
            </div>
        </div>

        <!-- Service Description -->
        @if($quotation->service_description)
        <div class="notes-section">
            <h3 style="font-size: 12px; color: #64748b; text-transform: uppercase; margin-bottom: 10px;">Service Description</h3>
            <div class="notes-box">
                {{ $quotation->service_description }}
            </div>
        </div>
        @endif

        <!-- Items Table -->
        <table class="items-table">
            <thead>
                <tr>
                    <th style="width: 80px;">Type</th>
                    <th>Description</th>
                    <th style="width: 80px;">Qty</th>
                    <th style="width: 120px;">Unit Price</th>
                    <th style="width: 120px;">Subtotal</th>
                </tr>
            </thead>
            <tbody>
                @foreach($quotation->items as $item)
                <tr>
                    <td>
                        <span class="item-type {{ $item->item_type }}">{{ $item->item_type }}</span>
                    </td>
                    <td>{{ $item->description }}</td>
                    <td>{{ $item->quantity }}</td>
                    <td>KSh {{ number_format($item->unit_price, 2) }}</td>
                    <td>KSh {{ number_format($item->subtotal, 2) }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>

        <!-- Totals -->
        <div class="totals-section">
            <div class="totals-left"></div>
            <div class="totals-right">
                <div class="totals-box">
                    <div class="totals-row">
                        <div class="totals-label">Products Total:</div>
                        <div class="totals-value">KSh {{ number_format($quotation->products_total, 2) }}</div>
                    </div>
                    <div class="totals-row">
                        <div class="totals-label">Installation/Services:</div>
                        <div class="totals-value">KSh {{ number_format($quotation->installation_total, 2) }}</div>
                    </div>
                    @if($quotation->installation_discount > 0)
                    <div class="totals-row discount-row">
                        <div class="totals-label">Discount ({{ $quotation->discount_percentage }}%):</div>
                        <div class="totals-value">- KSh {{ number_format($quotation->installation_discount, 2) }}</div>
                    </div>
                    @endif
                    <div class="totals-row total">
                        <div class="totals-label">Grand Total:</div>
                        <div class="totals-value">KSh {{ number_format($quotation->total, 2) }}</div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Terms & Conditions -->
        @if($quotation->terms_conditions)
        <div class="terms-section">
            <h3>Terms & Conditions</h3>
            <div class="terms-box">
                {!! nl2br(e($quotation->terms_conditions)) !!}
            </div>
        </div>
        @endif

        <!-- Notes -->
        @if($quotation->notes)
        <div class="notes-section">
            <h3 style="font-size: 12px; color: #64748b; text-transform: uppercase; margin-bottom: 10px;">Additional Notes</h3>
            <div class="notes-box">
                {{ $quotation->notes }}
            </div>
        </div>
        @endif

        <!-- Payment Details -->
        @if(($payment['mpesa_enabled'] ?? false) || ($payment['bank_enabled'] ?? false))
        <div class="notes-section" style="page-break-inside: avoid;">
            <h3 style="font-size: 12px; color: #64748b; text-transform: uppercase; margin-bottom: 10px;">Payment Details</h3>
            <div class="notes-box">
                <table style="width: 100%;">
                    <tr>
                        @if($payment['mpesa_enabled'] ?? false)
                        <td style="vertical-align: top; padding-right: 20px;">
                            <strong style="color: #22c55e;">M-PESA (Buy Goods & Services)</strong><br>
                            Till Number: <strong>{{ $payment['mpesa_till_number'] ?? '' }}</strong>
                        </td>
                        @endif
                        
                        @if($payment['bank_enabled'] ?? false)
                        <td style="vertical-align: top;">
                            <strong style="color: #0ea5e9;">Bank Transfer</strong><br>
                            Bank: {{ $payment['bank_name'] ?? '' }}<br>
                            Account Name: {{ $payment['bank_account_name'] ?? '' }}<br>
                            Account No: <strong>{{ $payment['bank_account_number'] ?? '' }}</strong>
                            @if(!empty($payment['bank_branch']))
                            <br>Branch: {{ $payment['bank_branch'] }}
                            @endif
                        </td>
                        @endif
                    </tr>
                </table>
            </div>
        </div>
        @endif

        <!-- Footer -->
        <div class="footer">
            <p>Thank you for your business!</p>
            <p>{{ $company['company_name'] ?? 'OneSpot Solutions Ltd' }} | {{ $company['company_website'] ?? 'www.onespotsolutionsltd.co.ke' }}</p>
        </div>
    </div>
</body>
</html>
