@extends('admin.layouts.app')

@section('title', 'Quotation ' . $quotation->quotation_number)

@section('content')
<div class="flex justify-between items-center mb-3">
    <a href="{{ route('admin.quotations.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Back to Quotations
    </a>
    <div class="flex gap-2">
        <a href="{{ route('admin.quotations.pdf', $quotation) }}" class="btn btn-primary">
            <i class="fas fa-file-pdf"></i> Download PDF
        </a>
        <a href="{{ route('admin.quotations.edit', $quotation) }}" class="btn btn-secondary">
            <i class="fas fa-edit"></i> Edit
        </a>
    </div>
</div>

<div class="grid grid-2">
    <!-- Quotation Info -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Quotation Details</h3>
            <span class="badge badge-{{ $quotation->status_badge['color'] }}">
                {{ $quotation->status_badge['label'] }}
            </span>
        </div>

        <div class="grid grid-2 mb-2">
            <div>
                <div class="text-muted" style="font-size: 0.8rem;">Quotation Number</div>
                <strong>{{ $quotation->quotation_number }}</strong>
            </div>
            <div>
                <div class="text-muted" style="font-size: 0.8rem;">Date Created</div>
                <strong>{{ $quotation->created_at->format('M d, Y') }}</strong>
            </div>
        </div>

        <div class="grid grid-2 mb-2">
            <div>
                <div class="text-muted" style="font-size: 0.8rem;">Valid Until</div>
                <strong class="{{ $quotation->is_expired ? 'text-danger' : '' }}">
                    {{ $quotation->valid_until?->format('M d, Y') ?? 'Not set' }}
                </strong>
            </div>
            <div>
                <div class="text-muted" style="font-size: 0.8rem;">Service Type</div>
                <strong>{{ ucfirst($quotation->service_type ?? 'N/A') }}</strong>
            </div>
        </div>

        @if($quotation->is_shop_customer)
        <div class="alert" style="background: rgba(34, 197, 94, 0.1); border: 1px solid rgba(34, 197, 94, 0.3); color: var(--success);">
            <i class="fas fa-check-circle"></i>
            <span>Shop customer - {{ $quotation->discount_percentage }}% installation discount applied</span>
        </div>
        @endif
    </div>

    <!-- Customer Info -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Customer Information</h3>
        </div>

        <div class="mb-2">
            <div class="text-muted" style="font-size: 0.8rem;">Name</div>
            <strong>{{ $quotation->customer_name }}</strong>
        </div>
        <div class="mb-2">
            <div class="text-muted" style="font-size: 0.8rem;">Email</div>
            <a href="mailto:{{ $quotation->customer_email }}" class="text-primary">{{ $quotation->customer_email }}</a>
        </div>
        <div class="mb-2">
            <div class="text-muted" style="font-size: 0.8rem;">Phone</div>
            <a href="tel:{{ $quotation->customer_phone }}" class="text-primary">{{ $quotation->customer_phone }}</a>
        </div>
        @if($quotation->site_address)
        <div>
            <div class="text-muted" style="font-size: 0.8rem;">Installation Site</div>
            <div>{{ $quotation->site_address }}</div>
        </div>
        @endif
    </div>
</div>

<!-- Quotation Items -->
<div class="card">
    <div class="card-header">
        <h3 class="card-title">Quotation Items</h3>
    </div>

    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th>Type</th>
                    <th>Description</th>
                    <th>Unit Price</th>
                    <th>Quantity</th>
                    <th>Subtotal</th>
                </tr>
            </thead>
            <tbody>
                @foreach($quotation->items as $item)
                <tr>
                    <td>
                        <span class="badge badge-{{ $item->item_type == 'product' ? 'primary' : ($item->item_type == 'service' ? 'info' : 'secondary') }}">
                            {{ ucfirst($item->item_type) }}
                        </span>
                    </td>
                    <td>{{ $item->description }}</td>
                    <td>KSh {{ number_format($item->unit_price, 2) }}</td>
                    <td>{{ $item->quantity }}</td>
                    <td><strong>KSh {{ number_format($item->subtotal, 2) }}</strong></td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <!-- Totals -->
    <div style="margin-top: 1.5rem; padding-top: 1rem; border-top: 1px solid rgba(255,255,255,0.1); max-width: 400px; margin-left: auto;">
        <div class="flex justify-between mb-1">
            <span>Products Total</span>
            <span>KSh {{ number_format($quotation->products_total, 2) }}</span>
        </div>
        <div class="flex justify-between mb-1">
            <span>Installation/Services</span>
            <span>KSh {{ number_format($quotation->installation_total, 2) }}</span>
        </div>
        @if($quotation->installation_discount > 0)
        <div class="flex justify-between mb-1 text-success">
            <span>Installation Discount ({{ $quotation->discount_percentage }}%)</span>
            <span>- KSh {{ number_format($quotation->installation_discount, 2) }}</span>
        </div>
        @endif
        <div class="flex justify-between" style="font-size: 1.25rem; font-weight: 700; margin-top: 0.5rem; padding-top: 0.5rem; border-top: 1px solid rgba(255,255,255,0.1);">
            <span>Total</span>
            <span>KSh {{ number_format($quotation->total, 2) }}</span>
        </div>
    </div>
</div>

@if($quotation->notes)
<div class="card">
    <div class="card-header">
        <h3 class="card-title">Notes</h3>
    </div>
    <p style="white-space: pre-line;">{{ $quotation->notes }}</p>
</div>
@endif
@endsection
