<x-guest-layout>
    <div class="auth-form-header">
        <h2>Reset Password</h2>
        <p>Remember your password? <a href="{{ route('login') }}">Sign in</a></p>
    </div>

    <p style="color: #94a3b8; font-size: 0.9rem; margin-bottom: 1.5rem; line-height: 1.6;">
        <i class="fas fa-info-circle" style="color: var(--primary);"></i>
        Enter your email address and we'll send you a link to reset your password.
    </p>

    <!-- Session Status -->
    @if (session('status'))
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i>
            {{ session('status') }}
        </div>
    @endif

    <!-- Validation Errors -->
    @if ($errors->any())
        <div class="alert alert-error">
            <i class="fas fa-exclamation-circle"></i>
            <div>
                @foreach ($errors->all() as $error)
                    <div>{{ $error }}</div>
                @endforeach
            </div>
        </div>
    @endif

    <form method="POST" action="{{ route('password.email') }}">
        @csrf

        <!-- Email Address -->
        <div class="form-group">
            <label for="email" class="form-label">Email Address</label>
            <div class="input-icon-wrapper">
                <i class="fas fa-envelope icon"></i>
                <input 
                    id="email" 
                    type="email" 
                    name="email" 
                    class="form-input" 
                    value="{{ old('email') }}" 
                    placeholder="Enter your email"
                    required 
                    autofocus
                >
            </div>
        </div>

        <!-- Submit Button -->
        <button type="submit" class="btn btn-primary">
            <i class="fas fa-paper-plane"></i>
            Send Reset Link
        </button>
    </form>

    <div style="text-align: center; margin-top: 2rem;">
        <a href="{{ route('login') }}" style="color: #64748b; font-size: 0.9rem; text-decoration: none;">
            <i class="fas fa-arrow-left"></i> Back to Login
        </a>
    </div>
</x-guest-layout>
