<x-guest-layout>
    <div class="auth-form-header">
        <h2>Welcome Back</h2>
        <p>Don't have an account? <a href="{{ route('register') }}">Create one free</a></p>
    </div>

    <!-- Session Status -->
    @if (session('status'))
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i>
            {{ session('status') }}
        </div>
    @endif

    <!-- Validation Errors -->
    @if ($errors->any())
        <div class="alert alert-error">
            <i class="fas fa-exclamation-circle"></i>
            <div>
                @foreach ($errors->all() as $error)
                    <div>{{ $error }}</div>
                @endforeach
            </div>
        </div>
    @endif

    <form method="POST" action="{{ route('login') }}">
        @csrf

        <!-- Email Address -->
        <div class="form-group">
            <label for="email" class="form-label">Email Address</label>
            <div class="input-icon-wrapper">
                <i class="fas fa-envelope icon"></i>
                <input 
                    id="email" 
                    type="email" 
                    name="email" 
                    class="form-input" 
                    value="{{ old('email') }}" 
                    placeholder="Enter your email"
                    required 
                    autofocus 
                    autocomplete="username"
                >
            </div>
        </div>

        <!-- Password -->
        <div class="form-group">
            <label for="password" class="form-label">Password</label>
            <div class="input-icon-wrapper">
                <i class="fas fa-lock icon"></i>
                <input 
                    id="password" 
                    type="password" 
                    name="password" 
                    class="form-input" 
                    placeholder="Enter your password"
                    required 
                    autocomplete="current-password"
                >
                <button type="button" class="toggle-password">
                    <i class="fas fa-eye"></i>
                </button>
            </div>
        </div>

        <!-- Remember Me & Forgot Password -->
        <div class="form-actions">
            <div class="form-check">
                <input id="remember_me" type="checkbox" name="remember">
                <label for="remember_me">Remember me</label>
            </div>

            @if (Route::has('password.request'))
                <a class="forgot-link" href="{{ route('password.request') }}">
                    Forgot password?
                </a>
            @endif
        </div>

        <!-- Submit Button -->
        <button type="submit" class="btn btn-primary">
            <i class="fas fa-sign-in-alt"></i>
            Sign In
        </button>
    </form>

    <div class="divider">
        <span>or continue with</span>
    </div>

    <div class="social-login">
        <a href="#" class="social-btn">
            <i class="fab fa-google"></i>
            Google
        </a>
        <a href="#" class="social-btn">
            <i class="fab fa-facebook-f"></i>
            Facebook
        </a>
    </div>
</x-guest-layout>
