<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\CustomerDashboardController;
use App\Http\Controllers\Admin\DashboardController as AdminDashboardController;
use App\Http\Controllers\Admin\ProductController as AdminProductController;
use App\Http\Controllers\Admin\CategoryController as AdminCategoryController;
use App\Http\Controllers\Admin\OrderController as AdminOrderController;
use App\Http\Controllers\Admin\QuotationController as AdminQuotationController;
use App\Http\Controllers\Admin\SettingsController as AdminSettingsController;
use App\Http\Controllers\Admin\UserController as AdminUserController;
use App\Http\Controllers\Shop\ShopController;
use App\Http\Controllers\Shop\CartController;
use App\Http\Controllers\Shop\CheckoutController;
use Illuminate\Support\Facades\Route;

// Public homepage - redirect to shop
Route::get('/', function () {
    return redirect()->route('shop.home');
});

// Customer dashboard
Route::get('/dashboard', [CustomerDashboardController::class, 'index'])
    ->middleware(['auth', 'verified'])->name('dashboard');

// Profile routes
Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

// Cart routes (authenticated users)
Route::middleware('auth')->prefix('cart')->name('cart.')->group(function () {
    Route::get('/', [CartController::class, 'index'])->name('index');
    Route::post('/add', [CartController::class, 'add'])->name('add');
    Route::patch('/{item}', [CartController::class, 'update'])->name('update');
    Route::delete('/{item}', [CartController::class, 'remove'])->name('remove');
    Route::delete('/clear', [CartController::class, 'clear'])->name('clear');
    Route::post('/checkout', [CheckoutController::class, 'store'])->name('checkout');
    Route::get('/order/confirmation/{order}', [CheckoutController::class, 'confirmation'])->name('shop.order.confirmation');
});

// Cart count API (works regardless of auth status)
Route::get('/cart/count', [CartController::class, 'count'])->name('cart.count');

// Admin routes
Route::middleware(['auth', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/', [AdminDashboardController::class, 'index'])->name('dashboard');
    
    // Products
    Route::resource('products', AdminProductController::class);
    Route::delete('products/images/{image}', [AdminProductController::class, 'deleteImage'])->name('products.delete-image');
    Route::post('products/images/{image}/primary', [AdminProductController::class, 'setPrimaryImage'])->name('products.set-primary-image');
    
    // Categories
    Route::resource('categories', AdminCategoryController::class);
    
    // Orders
    Route::get('orders', [AdminOrderController::class, 'index'])->name('orders.index');
    Route::get('orders/{order}', [AdminOrderController::class, 'show'])->name('orders.show');
    Route::patch('orders/{order}/status', [AdminOrderController::class, 'updateStatus'])->name('orders.update-status');
    Route::patch('orders/{order}/payment-status', [AdminOrderController::class, 'updatePaymentStatus'])->name('orders.update-payment-status');
    
    // Quotations
    Route::resource('quotations', AdminQuotationController::class);
    Route::get('quotations/{quotation}/pdf', [AdminQuotationController::class, 'downloadPdf'])->name('quotations.pdf');
    Route::post('quotations/{quotation}/send', [AdminQuotationController::class, 'sendEmail'])->name('quotations.send');
    
    // Users
    Route::get('users', [AdminUserController::class, 'index'])->name('users.index');
    Route::get('users/{user}', [AdminUserController::class, 'show'])->name('users.show');
    Route::patch('users/{user}/toggle-status', [AdminUserController::class, 'toggleStatus'])->name('users.toggle-status');
    
    // Settings
    Route::get('settings', [AdminSettingsController::class, 'index'])->name('settings.index');
    Route::post('settings', [AdminSettingsController::class, 'update'])->name('settings.update');
});

// Shop routes
Route::name('shop.')->group(function () {
    Route::get('/shop', [ShopController::class, 'home'])->name('home');
    Route::get('/shop/products', [ShopController::class, 'products'])->name('products');
    Route::get('/shop/products/{product}', [ShopController::class, 'showProduct'])->name('product');
    Route::get('/shop/categories', [ShopController::class, 'categories'])->name('categories');
    Route::get('/shop/installation', [ShopController::class, 'installation'])->name('installation');
    Route::get('/shop/contact', [ShopController::class, 'contact'])->name('contact');
    Route::post('/shop/contact', [ShopController::class, 'sendContactMessage'])->name('contact.send');
});

require __DIR__.'/auth.php';


