

<?php $__env->startSection('title', 'Users'); ?>

<?php $__env->startSection('content'); ?>
<div class="flex justify-between items-center mb-3">
    <h2 style="font-size: 1.5rem; font-weight: 600;">User Management</h2>
</div>

<!-- Filters -->
<div class="card mb-3">
    <form method="GET" action="<?php echo e(route('admin.users.index')); ?>" class="flex gap-3 items-center" style="flex-wrap: wrap;">
        <div class="form-group mb-0" style="flex: 1; min-width: 200px;">
            <input type="text" name="search" class="form-input" placeholder="Search by name or email..." value="<?php echo e(request('search')); ?>">
        </div>
        <div class="form-group mb-0">
            <select name="role" class="form-select" style="min-width: 150px;">
                <option value="">All Roles</option>
                <option value="admin" <?php echo e(request('role') == 'admin' ? 'selected' : ''); ?>>Admins</option>
                <option value="customer" <?php echo e(request('role') == 'customer' ? 'selected' : ''); ?>>Customers</option>
            </select>
        </div>
        <button type="submit" class="btn btn-primary">
            <i class="fas fa-search"></i> Search
        </button>
        <?php if(request()->hasAny(['search', 'role'])): ?>
            <a href="<?php echo e(route('admin.users.index')); ?>" class="btn btn-secondary">Clear</a>
        <?php endif; ?>
    </form>
</div>

<!-- Users Table -->
<div class="card">
    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th>User</th>
                    <th>Email</th>
                    <th>Role</th>
                    <th>Orders</th>
                    <th>Total Spent</th>
                    <th>Status</th>
                    <th>Joined</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <div style="display: flex; align-items: center; gap: 0.75rem;">
                                <div style="width: 40px; height: 40px; border-radius: 50%; background: var(--primary); display: flex; align-items: center; justify-content: center; font-weight: 600;">
                                    <?php echo e(strtoupper(substr($user->name, 0, 1))); ?>

                                </div>
                                <div>
                                    <div style="font-weight: 500;"><?php echo e($user->name); ?></div>
                                    <?php if($user->phone): ?>
                                        <div style="font-size: 0.8rem; color: #64748b;"><?php echo e($user->phone); ?></div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </td>
                        <td><?php echo e($user->email); ?></td>
                        <td>
                            <span class="badge badge-<?php echo e($user->role === 'admin' ? 'primary' : 'secondary'); ?>">
                                <?php echo e(ucfirst($user->role)); ?>

                            </span>
                        </td>
                        <td><?php echo e($user->orders_count ?? $user->orders()->count()); ?></td>
                        <td>KSh <?php echo e(number_format($user->total_spent, 2)); ?></td>
                        <td>
                            <span class="badge badge-<?php echo e($user->is_active ? 'success' : 'danger'); ?>">
                                <?php echo e($user->is_active ? 'Active' : 'Inactive'); ?>

                            </span>
                        </td>
                        <td><?php echo e($user->created_at->format('M d, Y')); ?></td>
                        <td>
                            <div style="display: flex; gap: 0.5rem;">
                                <a href="<?php echo e(route('admin.users.show', $user)); ?>" class="btn btn-secondary btn-sm" title="View Details">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <?php if($user->id !== auth()->id()): ?>
                                    <form action="<?php echo e(route('admin.users.toggle-status', $user)); ?>" method="POST" style="display: inline;">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PATCH'); ?>
                                        <button type="submit" class="btn btn-<?php echo e($user->is_active ? 'warning' : 'success'); ?> btn-sm" 
                                                title="<?php echo e($user->is_active ? 'Deactivate' : 'Activate'); ?>"
                                                onclick="return confirm('<?php echo e($user->is_active ? 'Deactivate' : 'Activate'); ?> this user?')">
                                            <i class="fas fa-<?php echo e($user->is_active ? 'ban' : 'check'); ?>"></i>
                                        </button>
                                    </form>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="8" class="text-muted text-center" style="padding: 2rem;">
                            <i class="fas fa-users" style="font-size: 2rem; margin-bottom: 0.5rem; display: block;"></i>
                            No users found
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <?php if($users->hasPages()): ?>
        <div class="pagination" style="margin-top: 1rem;">
            <?php echo e($users->links()); ?>

        </div>
    <?php endif; ?>
</div>

<style>
    .btn-warning {
        background: rgba(245, 158, 11, 0.2);
        color: var(--warning);
        border: 1px solid rgba(245, 158, 11, 0.3);
    }
    .btn-warning:hover {
        background: var(--warning);
        color: white;
    }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\shop\resources\views/admin/users/index.blade.php ENDPATH**/ ?>