

<?php $__env->startSection('title', 'Shopping Cart'); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="page-header">
        <h1><i class="fas fa-shopping-cart"></i> Your Cart</h1>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i>
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="alert alert-error">
            <i class="fas fa-exclamation-circle"></i>
            <?php echo e(session('error')); ?>

        </div>
    <?php endif; ?>

    <?php if($cartItems->isEmpty()): ?>
        <div class="empty-cart">
            <div class="empty-cart-icon">
                <i class="fas fa-shopping-cart"></i>
            </div>
            <h2>Your cart is empty</h2>
            <p>Looks like you haven't added any products yet.</p>
            <a href="<?php echo e(route('shop.products')); ?>" class="btn btn-primary">
                <i class="fas fa-shopping-bag"></i> Start Shopping
            </a>
        </div>
    <?php else: ?>
        <div class="cart-layout">
            <div class="cart-items">
                <?php $__currentLoopData = $cartItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="cart-item">
                        <div class="cart-item-image">
                            <?php if($item->product->primaryImage): ?>
                                <img src="<?php echo e(asset('storage/' . $item->product->primaryImage->path)); ?>" alt="<?php echo e($item->product->name); ?>">
                            <?php else: ?>
                                <div class="placeholder-image">
                                    <i class="fas fa-box"></i>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="cart-item-details">
                            <h3 class="item-name">
                                <a href="<?php echo e(route('shop.product', $item->product)); ?>"><?php echo e($item->product->name); ?></a>
                            </h3>
                            <div class="item-meta">
                                <?php if($item->product->category): ?>
                                    <span class="item-category"><?php echo e($item->product->category->name); ?></span>
                                <?php endif; ?>
                                <?php if($item->product->is_on_sale): ?>
                                    <span class="item-badge sale">-<?php echo e($item->product->discount_percentage); ?>%</span>
                                <?php endif; ?>
                            </div>
                            <div class="item-price">
                                <span class="current-price">KSh <?php echo e(number_format($item->product->effective_price, 2)); ?></span>
                                <?php if($item->product->is_on_sale): ?>
                                    <span class="original-price">KSh <?php echo e(number_format($item->product->price, 2)); ?></span>
                                <?php endif; ?>
                            </div>
                            
                            <?php if($item->product->requires_installation): ?>
                                <div class="installation-toggle">
                                    <form action="<?php echo e(route('cart.update', $item)); ?>" method="POST" class="inline-form">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PATCH'); ?>
                                        <input type="hidden" name="quantity" value="<?php echo e($item->quantity); ?>">
                                        <label class="checkbox-label">
                                            <input type="checkbox" name="include_installation" value="1" 
                                                   onchange="this.form.submit()" <?php echo e($item->include_installation ? 'checked' : ''); ?>>
                                            <span>Include installation (+KSh <?php echo e(number_format($item->product->installation_price, 2)); ?>)</span>
                                        </label>
                                    </form>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="cart-item-quantity">
                            <form action="<?php echo e(route('cart.update', $item)); ?>" method="POST" class="quantity-form">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PATCH'); ?>
                                <input type="hidden" name="include_installation" value="<?php echo e($item->include_installation ? 1 : 0); ?>">
                                <button type="button" class="qty-btn minus" onclick="updateQuantity(this, -1)">-</button>
                                <input type="number" name="quantity" value="<?php echo e($item->quantity); ?>" min="1" max="<?php echo e($item->product->stock_quantity); ?>" class="qty-input">
                                <button type="button" class="qty-btn plus" onclick="updateQuantity(this, 1)">+</button>
                            </form>
                        </div>
                        
                        <div class="cart-item-total">
                            <span class="total-label">Subtotal</span>
                            <span class="total-value">KSh <?php echo e(number_format($item->total, 2)); ?></span>
                            <?php if($item->installation_cost > 0): ?>
                                <span class="installation-note">(incl. installation)</span>
                            <?php endif; ?>
                        </div>
                        
                        <form action="<?php echo e(route('cart.remove', $item)); ?>" method="POST" class="remove-form">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="remove-btn" title="Remove item">
                                <i class="fas fa-trash"></i>
                            </button>
                        </form>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            
            <div class="cart-summary">
                <div class="summary-card">
                    <h3>Order Summary</h3>
                    
                    <div class="summary-row">
                        <span>Subtotal (<?php echo e($cartItems->sum('quantity')); ?> items)</span>
                        <span>KSh <?php echo e(number_format($subtotal, 2)); ?></span>
                    </div>
                    
                    <?php if($installationTotal > 0): ?>
                        <div class="summary-row">
                            <span>Installation</span>
                            <span>KSh <?php echo e(number_format($installationTotal, 2)); ?></span>
                        </div>
                    <?php endif; ?>
                    
                    <div class="summary-row total">
                        <span>Total</span>
                        <span>KSh <?php echo e(number_format($total, 2)); ?></span>
                    </div>
                    
                    <form action="<?php echo e(route('cart.checkout')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="btn btn-primary btn-block">
                            <i class="fas fa-credit-card"></i> Proceed to Checkout
                        </button>
                    </form>
                    
                    <form action="<?php echo e(route('cart.clear')); ?>" method="POST" class="clear-cart-form">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-secondary btn-block" onclick="return confirm('Clear all items from cart?')">
                            <i class="fas fa-trash-alt"></i> Clear Cart
                        </button>
                    </form>
                    
                    <a href="<?php echo e(route('shop.products')); ?>" class="continue-shopping">
                        <i class="fas fa-arrow-left"></i> Continue Shopping
                    </a>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>

<style>
    .container {
        max-width: 1400px;
        margin: 0 auto;
        padding: 2rem;
    }

    .page-header {
        margin-bottom: 2rem;
    }

    .page-header h1 {
        font-size: 2rem;
        font-weight: 700;
        display: flex;
        align-items: center;
        gap: 0.75rem;
    }

    .page-header h1 i {
        color: var(--primary);
    }

    .alert {
        padding: 1rem 1.25rem;
        border-radius: 8px;
        margin-bottom: 1.5rem;
        display: flex;
        align-items: center;
        gap: 0.75rem;
    }

    .alert-success {
        background: rgba(34, 197, 94, 0.2);
        border: 1px solid rgba(34, 197, 94, 0.3);
        color: var(--success);
    }

    .alert-error {
        background: rgba(239, 68, 68, 0.2);
        border: 1px solid rgba(239, 68, 68, 0.3);
        color: var(--danger);
    }

    /* Empty Cart */
    .empty-cart {
        text-align: center;
        padding: 4rem 2rem;
        background: rgba(30, 41, 59, 0.6);
        border: 1px solid rgba(255, 255, 255, 0.1);
        border-radius: 16px;
    }

    .empty-cart-icon {
        width: 100px;
        height: 100px;
        margin: 0 auto 1.5rem;
        background: rgba(14, 165, 233, 0.1);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .empty-cart-icon i {
        font-size: 2.5rem;
        color: var(--primary);
    }

    .empty-cart h2 {
        font-size: 1.5rem;
        margin-bottom: 0.5rem;
    }

    .empty-cart p {
        color: #94a3b8;
        margin-bottom: 1.5rem;
    }

    /* Cart Layout */
    .cart-layout {
        display: grid;
        grid-template-columns: 1fr 360px;
        gap: 2rem;
        align-items: start;
    }

    /* Cart Items */
    .cart-items {
        display: flex;
        flex-direction: column;
        gap: 1rem;
    }

    .cart-item {
        background: rgba(30, 41, 59, 0.6);
        border: 1px solid rgba(255, 255, 255, 0.1);
        border-radius: 12px;
        padding: 1.25rem;
        display: grid;
        grid-template-columns: 100px 1fr auto auto auto;
        gap: 1.25rem;
        align-items: center;
    }

    .cart-item-image {
        width: 100px;
        height: 100px;
        border-radius: 8px;
        overflow: hidden;
        background: rgba(15, 23, 42, 0.8);
    }

    .cart-item-image img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .placeholder-image {
        width: 100%;
        height: 100%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #475569;
    }

    .placeholder-image i {
        font-size: 2rem;
    }

    .cart-item-details {
        min-width: 0;
    }

    .item-name {
        font-size: 1rem;
        font-weight: 600;
        margin-bottom: 0.25rem;
    }

    .item-name a {
        color: inherit;
        text-decoration: none;
    }

    .item-name a:hover {
        color: var(--primary);
    }

    .item-meta {
        display: flex;
        gap: 0.5rem;
        margin-bottom: 0.5rem;
    }

    .item-category {
        font-size: 0.8rem;
        color: var(--primary);
    }

    .item-badge {
        font-size: 0.7rem;
        padding: 2px 6px;
        border-radius: 4px;
        font-weight: 600;
    }

    .item-badge.sale {
        background: rgba(239, 68, 68, 0.2);
        color: var(--danger);
    }

    .item-price {
        display: flex;
        gap: 0.5rem;
        align-items: center;
    }

    .current-price {
        font-weight: 600;
        color: var(--success);
    }

    .original-price {
        font-size: 0.875rem;
        color: #64748b;
        text-decoration: line-through;
    }

    .installation-toggle {
        margin-top: 0.75rem;
    }

    .checkbox-label {
        display: flex;
        align-items: center;
        gap: 0.5rem;
        font-size: 0.85rem;
        color: #94a3b8;
        cursor: pointer;
    }

    .checkbox-label input {
        accent-color: var(--primary);
    }

    /* Quantity Controls */
    .cart-item-quantity {
        display: flex;
        align-items: center;
    }

    .quantity-form {
        display: flex;
        align-items: center;
        gap: 0.25rem;
    }

    .qty-btn {
        width: 32px;
        height: 32px;
        border: 1px solid rgba(255, 255, 255, 0.2);
        background: rgba(30, 41, 59, 0.8);
        color: #e2e8f0;
        border-radius: 6px;
        cursor: pointer;
        font-size: 1rem;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .qty-btn:hover {
        background: var(--primary);
        border-color: var(--primary);
    }

    .qty-input {
        width: 50px;
        text-align: center;
        padding: 0.5rem;
        border: 1px solid rgba(255, 255, 255, 0.1);
        background: rgba(15, 23, 42, 0.8);
        color: #e2e8f0;
        border-radius: 6px;
        font-size: 0.875rem;
    }

    .qty-input::-webkit-outer-spin-button,
    .qty-input::-webkit-inner-spin-button {
        -webkit-appearance: none;
    }

    /* Cart Item Total */
    .cart-item-total {
        text-align: right;
        min-width: 120px;
    }

    .total-label {
        display: block;
        font-size: 0.75rem;
        color: #64748b;
        margin-bottom: 0.25rem;
    }

    .total-value {
        font-size: 1.125rem;
        font-weight: 700;
        color: var(--success);
    }

    .installation-note {
        display: block;
        font-size: 0.7rem;
        color: #64748b;
    }

    /* Remove Button */
    .remove-btn {
        width: 36px;
        height: 36px;
        border: 1px solid rgba(239, 68, 68, 0.3);
        background: rgba(239, 68, 68, 0.1);
        color: var(--danger);
        border-radius: 8px;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .remove-btn:hover {
        background: var(--danger);
        color: white;
    }

    /* Cart Summary */
    .summary-card {
        background: rgba(30, 41, 59, 0.8);
        border: 1px solid rgba(255, 255, 255, 0.1);
        border-radius: 16px;
        padding: 1.5rem;
        position: sticky;
        top: 100px;
    }

    .summary-card h3 {
        font-size: 1.125rem;
        font-weight: 600;
        margin-bottom: 1.25rem;
        padding-bottom: 1rem;
        border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    }

    .summary-row {
        display: flex;
        justify-content: space-between;
        padding: 0.75rem 0;
        font-size: 0.9rem;
        color: #94a3b8;
    }

    .summary-row.total {
        font-size: 1.125rem;
        font-weight: 700;
        color: #e2e8f0;
        border-top: 1px solid rgba(255, 255, 255, 0.1);
        margin-top: 0.5rem;
        padding-top: 1rem;
    }

    .summary-row.total span:last-child {
        color: var(--success);
    }

    .btn {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 0.5rem;
        padding: 0.75rem 1.5rem;
        border-radius: 8px;
        font-weight: 500;
        font-size: 0.875rem;
        text-decoration: none;
        border: none;
        cursor: pointer;
        transition: all 0.2s;
    }

    .btn-primary {
        background: var(--primary);
        color: white;
    }

    .btn-primary:hover {
        background: var(--primary-dark);
    }

    .btn-secondary {
        background: rgba(100, 116, 139, 0.2);
        color: #94a3b8;
        border: 1px solid rgba(100, 116, 139, 0.3);
    }

    .btn-secondary:hover {
        background: rgba(100, 116, 139, 0.3);
        color: #e2e8f0;
    }

    .btn-block {
        width: 100%;
        margin-top: 1rem;
    }

    .continue-shopping {
        display: block;
        text-align: center;
        margin-top: 1rem;
        color: var(--primary);
        font-size: 0.875rem;
    }

    .continue-shopping:hover {
        text-decoration: underline;
    }

    .inline-form {
        display: inline;
    }

    .clear-cart-form {
        margin-top: 0;
    }

    /* Responsive */
    @media (max-width: 1024px) {
        .cart-layout {
            grid-template-columns: 1fr;
        }

        .cart-item {
            grid-template-columns: 80px 1fr;
            grid-template-rows: auto auto;
        }

        .cart-item-quantity,
        .cart-item-total,
        .remove-form {
            grid-column: 2;
        }
    }

    @media (max-width: 640px) {
        .cart-item {
            grid-template-columns: 1fr;
            text-align: center;
        }

        .cart-item-image {
            margin: 0 auto;
        }

        .item-meta,
        .item-price {
            justify-content: center;
        }

        .quantity-form {
            justify-content: center;
        }

        .cart-item-total {
            text-align: center;
        }
    }
</style>

<script>
    function updateQuantity(btn, delta) {
        const form = btn.closest('.quantity-form');
        const input = form.querySelector('.qty-input');
        const newValue = parseInt(input.value) + delta;
        const max = parseInt(input.max) || 100;
        
        if (newValue >= 1 && newValue <= max) {
            input.value = newValue;
            form.submit();
        }
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('shop.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\shop\resources\views/shop/cart.blade.php ENDPATH**/ ?>