

<?php $__env->startSection('title', 'Installation Services - Onespot Solutions Shop'); ?>
<?php $__env->startSection('description', 'Professional security equipment installation services - CCTV setup, access control installation, and more.'); ?>

<?php $__env->startSection('content'); ?>
<style>
    .hero-section {
        background: linear-gradient(135deg, rgba(14, 165, 233, 0.1) 0%, rgba(34, 197, 94, 0.1) 100%);
        padding: 4rem 2rem;
        text-align: center;
        border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    }

    .hero-section .highlight {
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
        background: rgba(34, 197, 94, 0.2);
        color: var(--success);
        padding: 0.5rem 1rem;
        border-radius: 999px;
        font-weight: 600;
        margin-bottom: 1rem;
    }

    .hero-section h1 {
        font-size: 2.75rem;
        font-weight: 700;
        margin-bottom: 1rem;
    }

    .hero-section h1 span {
        background: linear-gradient(90deg, #0ea5e9, #22c55e);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
    }

    .hero-section p {
        color: #94a3b8;
        font-size: 1.1rem;
        max-width: 600px;
        margin: 0 auto 2rem;
    }

    .services-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 2rem;
        margin-bottom: 4rem;
    }

    .service-card {
        background: rgba(30, 41, 59, 0.6);
        border: 1px solid rgba(255, 255, 255, 0.1);
        border-radius: 16px;
        padding: 2rem;
        transition: all 0.3s;
    }

    .service-card:hover {
        transform: translateY(-5px);
        border-color: rgba(14, 165, 233, 0.3);
    }

    .service-icon {
        width: 60px;
        height: 60px;
        background: rgba(14, 165, 233, 0.1);
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-bottom: 1.5rem;
    }

    .service-icon i {
        font-size: 1.5rem;
        color: var(--primary);
    }

    .service-card h3 {
        font-size: 1.25rem;
        font-weight: 600;
        margin-bottom: 0.75rem;
    }

    .service-card p {
        color: #94a3b8;
        font-size: 0.9rem;
        line-height: 1.6;
        margin-bottom: 1rem;
    }

    .service-features {
        list-style: none;
    }

    .service-features li {
        display: flex;
        align-items: center;
        gap: 0.5rem;
        color: #94a3b8;
        font-size: 0.85rem;
        margin-bottom: 0.5rem;
    }

    .service-features li i {
        color: var(--success);
        font-size: 0.75rem;
    }

    .process-section {
        background: rgba(15, 23, 42, 0.5);
        padding: 4rem 2rem;
        margin: 0 -2rem;
    }

    .process-section h2 {
        text-align: center;
        font-size: 2rem;
        margin-bottom: 3rem;
    }

    .process-steps {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 2rem;
        max-width: 1200px;
        margin: 0 auto;
    }

    .process-step {
        text-align: center;
        position: relative;
    }

    .step-number {
        width: 50px;
        height: 50px;
        background: linear-gradient(135deg, var(--primary), #22c55e);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.25rem;
        font-weight: 700;
        margin: 0 auto 1rem;
    }

    .process-step h4 {
        font-size: 1.1rem;
        margin-bottom: 0.5rem;
    }

    .process-step p {
        color: #64748b;
        font-size: 0.9rem;
    }

    .pricing-section {
        margin-top: 4rem;
    }

    .pricing-section h2 {
        text-align: center;
        font-size: 2rem;
        margin-bottom: 3rem;
    }

    .pricing-cards {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        gap: 2rem;
    }

    .pricing-card {
        background: rgba(30, 41, 59, 0.6);
        border: 1px solid rgba(255, 255, 255, 0.1);
        border-radius: 16px;
        padding: 2rem;
        text-align: center;
        transition: all 0.3s;
    }

    .pricing-card.featured {
        border-color: var(--primary);
        position: relative;
    }

    .pricing-card.featured::before {
        content: 'Most Popular';
        position: absolute;
        top: -12px;
        left: 50%;
        transform: translateX(-50%);
        background: var(--primary);
        color: white;
        padding: 0.25rem 1rem;
        border-radius: 999px;
        font-size: 0.75rem;
        font-weight: 600;
    }

    .pricing-card h3 {
        font-size: 1.25rem;
        margin-bottom: 1rem;
    }

    .pricing-card .price {
        font-size: 2.5rem;
        font-weight: 700;
        color: var(--success);
        margin-bottom: 0.5rem;
    }

    .pricing-card .price-note {
        color: #64748b;
        font-size: 0.85rem;
        margin-bottom: 1.5rem;
    }

    .pricing-features {
        list-style: none;
        text-align: left;
        margin-bottom: 1.5rem;
    }

    .pricing-features li {
        display: flex;
        align-items: center;
        gap: 0.5rem;
        padding: 0.5rem 0;
        border-bottom: 1px solid rgba(255, 255, 255, 0.05);
        font-size: 0.9rem;
        color: #94a3b8;
    }

    .pricing-features li i.fa-check {
        color: var(--success);
    }

    .pricing-features li i.fa-times {
        color: #64748b;
    }

    .cta-section {
        background: linear-gradient(135deg, rgba(14, 165, 233, 0.15) 0%, rgba(34, 197, 94, 0.15) 100%);
        border: 1px solid rgba(14, 165, 233, 0.2);
        border-radius: 20px;
        padding: 3rem;
        text-align: center;
        margin-top: 4rem;
    }

    .cta-section h2 {
        font-size: 1.75rem;
        margin-bottom: 1rem;
    }

    .cta-section p {
        color: #94a3b8;
        margin-bottom: 1.5rem;
    }

    @media (max-width: 768px) {
        .hero-section h1 {
            font-size: 2rem;
        }
    }
</style>

<!-- Hero Section -->
<div class="hero-section">
    <div class="highlight">
        <i class="fas fa-percent"></i>
        <span>10% OFF for Shop Customers</span>
    </div>
    <h1>Professional <span>Installation Services</span></h1>
    <p>Our certified technicians ensure your security equipment is set up correctly for maximum protection and reliability.</p>
    <a href="<?php echo e(route('shop.contact')); ?>" class="btn btn-primary" style="padding: 1rem 2rem;">
        <i class="fas fa-file-invoice"></i> Request Installation Quote
    </a>
</div>

<!-- Main Content -->
<div class="main-content">
    <!-- Services Grid -->
    <div class="services-grid">
        <div class="service-card">
            <div class="service-icon">
                <i class="fas fa-video"></i>
            </div>
            <h3>CCTV Installation</h3>
            <p>Complete CCTV system setup including camera placement, NVR/DVR configuration, and remote viewing setup.</p>
            <ul class="service-features">
                <li><i class="fas fa-check"></i> Camera positioning & mounting</li>
                <li><i class="fas fa-check"></i> Cable routing & management</li>
                <li><i class="fas fa-check"></i> NVR/DVR setup & configuration</li>
                <li><i class="fas fa-check"></i> Mobile app remote access</li>
            </ul>
        </div>

        <div class="service-card">
            <div class="service-icon">
                <i class="fas fa-fingerprint"></i>
            </div>
            <h3>Access Control</h3>
            <p>Biometric and card-based access control installation for offices, buildings, and residential properties.</p>
            <ul class="service-features">
                <li><i class="fas fa-check"></i> Device mounting & wiring</li>
                <li><i class="fas fa-check"></i> User enrollment & setup</li>
                <li><i class="fas fa-check"></i> Integration with door locks</li>
                <li><i class="fas fa-check"></i> Software configuration</li>
            </ul>
        </div>

        <div class="service-card">
            <div class="service-icon">
                <i class="fas fa-lock"></i>
            </div>
            <h3>Smart Lock Installation</h3>
            <p>Digital and smart lock installation with app configuration and user access setup.</p>
            <ul class="service-features">
                <li><i class="fas fa-check"></i> Door preparation & fitting</li>
                <li><i class="fas fa-check"></i> Lock programming</li>
                <li><i class="fas fa-check"></i> App setup & pairing</li>
                <li><i class="fas fa-check"></i> User code configuration</li>
            </ul>
        </div>

        <div class="service-card">
            <div class="service-icon">
                <i class="fas fa-bolt"></i>
            </div>
            <h3>Electric Fencing</h3>
            <p>Perimeter electric fence installation with energizer setup and zone configuration.</p>
            <ul class="service-features">
                <li><i class="fas fa-check"></i> Post installation</li>
                <li><i class="fas fa-check"></i> Wire stringing & tensioning</li>
                <li><i class="fas fa-check"></i> Energizer installation</li>
                <li><i class="fas fa-check"></i> Zone & alarm setup</li>
            </ul>
        </div>

        <div class="service-card">
            <div class="service-icon">
                <i class="fas fa-network-wired"></i>
            </div>
            <h3>Network Setup</h3>
            <p>Structured cabling and network infrastructure for security system connectivity.</p>
            <ul class="service-features">
                <li><i class="fas fa-check"></i> Cable running & termination</li>
                <li><i class="fas fa-check"></i> Switch & router setup</li>
                <li><i class="fas fa-check"></i> IP configuration</li>
                <li><i class="fas fa-check"></i> Network testing</li>
            </ul>
        </div>

        <div class="service-card">
            <div class="service-icon">
                <i class="fas fa-tools"></i>
            </div>
            <h3>Maintenance & Support</h3>
            <p>Ongoing maintenance contracts and technical support for all installed systems.</p>
            <ul class="service-features">
                <li><i class="fas fa-check"></i> Regular system checkups</li>
                <li><i class="fas fa-check"></i> Firmware updates</li>
                <li><i class="fas fa-check"></i> Troubleshooting & repairs</li>
                <li><i class="fas fa-check"></i> Priority support</li>
            </ul>
        </div>
    </div>

    <!-- Process Section -->
    <div class="process-section">
        <h2>Our Installation Process</h2>
        <div class="process-steps">
            <div class="process-step">
                <div class="step-number">1</div>
                <h4>Consultation</h4>
                <p>Free site survey and consultation to understand your security needs</p>
            </div>
            <div class="process-step">
                <div class="step-number">2</div>
                <h4>Quotation</h4>
                <p>Detailed quote with itemized costs for equipment and installation</p>
            </div>
            <div class="process-step">
                <div class="step-number">3</div>
                <h4>Installation</h4>
                <p>Professional installation by our certified technicians</p>
            </div>
            <div class="process-step">
                <div class="step-number">4</div>
                <h4>Training</h4>
                <p>Complete user training on system operation and maintenance</p>
            </div>
        </div>
    </div>

    <!-- Pricing Section -->
    <div class="pricing-section">
        <h2>Installation Packages</h2>
        <div class="pricing-cards">
            <div class="pricing-card">
                <h3>Basic</h3>
                <div class="price">KSh 5,000</div>
                <div class="price-note">Starting price</div>
                <ul class="pricing-features">
                    <li><i class="fas fa-check"></i> Up to 4 cameras</li>
                    <li><i class="fas fa-check"></i> Basic cable routing</li>
                    <li><i class="fas fa-check"></i> NVR setup</li>
                    <li><i class="fas fa-check"></i> Mobile app config</li>
                    <li><i class="fas fa-times"></i> Extended warranty</li>
                </ul>
                <a href="<?php echo e(route('shop.contact')); ?>" class="btn btn-secondary" style="width: 100%;">Get Quote</a>
            </div>

            <div class="pricing-card featured">
                <h3>Standard</h3>
                <div class="price">KSh 15,000</div>
                <div class="price-note">Starting price</div>
                <ul class="pricing-features">
                    <li><i class="fas fa-check"></i> Up to 8 cameras</li>
                    <li><i class="fas fa-check"></i> Concealed cabling</li>
                    <li><i class="fas fa-check"></i> NVR + remote access</li>
                    <li><i class="fas fa-check"></i> Mobile app config</li>
                    <li><i class="fas fa-check"></i> 6-month support</li>
                </ul>
                <a href="<?php echo e(route('shop.contact')); ?>" class="btn btn-primary" style="width: 100%;">Get Quote</a>
            </div>

            <div class="pricing-card">
                <h3>Enterprise</h3>
                <div class="price">Custom</div>
                <div class="price-note">Based on requirements</div>
                <ul class="pricing-features">
                    <li><i class="fas fa-check"></i> Unlimited devices</li>
                    <li><i class="fas fa-check"></i> Full infrastructure</li>
                    <li><i class="fas fa-check"></i> Multi-site setup</li>
                    <li><i class="fas fa-check"></i> Integration services</li>
                    <li><i class="fas fa-check"></i> Annual maintenance</li>
                </ul>
                <a href="<?php echo e(route('shop.contact')); ?>" class="btn btn-secondary" style="width: 100%;">Contact Us</a>
            </div>
        </div>
    </div>

    <!-- CTA Section -->
    <div class="cta-section">
        <h2>Ready to Get Started?</h2>
        <p>Contact us today for a free consultation and quotation</p>
        <div style="display: flex; gap: 1rem; justify-content: center; flex-wrap: wrap;">
            <a href="<?php echo e(route('shop.contact')); ?>" class="btn btn-primary" style="padding: 1rem 2rem;">
                <i class="fas fa-envelope"></i> Request Quote
            </a>
            <a href="tel:+254700000000" class="btn btn-secondary" style="padding: 1rem 2rem;">
                <i class="fas fa-phone"></i> Call Us Now
            </a>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('shop.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\shop\resources\views/shop/installation.blade.php ENDPATH**/ ?>