

<?php $__env->startSection('title', 'User Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="flex justify-between items-center mb-3">
    <div>
        <a href="<?php echo e(route('admin.users.index')); ?>" class="btn btn-secondary btn-sm mb-2">
            <i class="fas fa-arrow-left"></i> Back to Users
        </a>
        <h2 style="font-size: 1.5rem; font-weight: 600;"><?php echo e($user->name); ?></h2>
    </div>
    <?php if($user->id !== auth()->id()): ?>
        <form action="<?php echo e(route('admin.users.toggle-status', $user)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PATCH'); ?>
            <button type="submit" class="btn btn-<?php echo e($user->is_active ? 'warning' : 'success'); ?>" 
                    onclick="return confirm('<?php echo e($user->is_active ? 'Deactivate' : 'Activate'); ?> this user?')">
                <i class="fas fa-<?php echo e($user->is_active ? 'ban' : 'check'); ?>"></i>
                <?php echo e($user->is_active ? 'Deactivate User' : 'Activate User'); ?>

            </button>
        </form>
    <?php endif; ?>
</div>

<div class="grid grid-2">
    <!-- User Info -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">User Information</h3>
            <span class="badge badge-<?php echo e($user->is_active ? 'success' : 'danger'); ?>">
                <?php echo e($user->is_active ? 'Active' : 'Inactive'); ?>

            </span>
        </div>
        
        <div style="display: flex; align-items: center; gap: 1rem; margin-bottom: 1.5rem;">
            <div style="width: 64px; height: 64px; border-radius: 50%; background: var(--primary); display: flex; align-items: center; justify-content: center; font-size: 1.5rem; font-weight: 600;">
                <?php echo e(strtoupper(substr($user->name, 0, 1))); ?>

            </div>
            <div>
                <h3 style="margin-bottom: 0.25rem;"><?php echo e($user->name); ?></h3>
                <span class="badge badge-<?php echo e($user->role === 'admin' ? 'primary' : 'secondary'); ?>">
                    <?php echo e(ucfirst($user->role)); ?>

                </span>
            </div>
        </div>

        <table style="width: 100%;">
            <tr>
                <td style="padding: 0.5rem 0; color: #64748b; width: 120px;">Email</td>
                <td style="padding: 0.5rem 0;"><?php echo e($user->email); ?></td>
            </tr>
            <tr>
                <td style="padding: 0.5rem 0; color: #64748b;">Phone</td>
                <td style="padding: 0.5rem 0;"><?php echo e($user->phone ?? '-'); ?></td>
            </tr>
            <tr>
                <td style="padding: 0.5rem 0; color: #64748b;">Address</td>
                <td style="padding: 0.5rem 0;"><?php echo e($user->address ?? '-'); ?></td>
            </tr>
            <tr>
                <td style="padding: 0.5rem 0; color: #64748b;">City</td>
                <td style="padding: 0.5rem 0;"><?php echo e($user->city ?? '-'); ?></td>
            </tr>
            <tr>
                <td style="padding: 0.5rem 0; color: #64748b;">County</td>
                <td style="padding: 0.5rem 0;"><?php echo e($user->county ?? '-'); ?></td>
            </tr>
            <tr>
                <td style="padding: 0.5rem 0; color: #64748b;">Joined</td>
                <td style="padding: 0.5rem 0;"><?php echo e($user->created_at->format('M d, Y H:i')); ?></td>
            </tr>
        </table>
    </div>

    <!-- Stats -->
    <div>
        <div class="stats-grid" style="grid-template-columns: repeat(2, 1fr);">
            <div class="stat-card primary">
                <div class="stat-icon">
                    <i class="fas fa-shopping-cart"></i>
                </div>
                <div class="stat-value"><?php echo e($user->orders->count()); ?></div>
                <div class="stat-label">Total Orders</div>
            </div>
            <div class="stat-card success">
                <div class="stat-icon">
                    <i class="fas fa-coins"></i>
                </div>
                <div class="stat-value">KSh <?php echo e(number_format($user->total_spent, 0)); ?></div>
                <div class="stat-label">Total Spent</div>
            </div>
        </div>

        <!-- Recent Orders -->
        <div class="card mt-2">
            <div class="card-header">
                <h3 class="card-title">Recent Orders</h3>
            </div>
            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>Order #</th>
                            <th>Total</th>
                            <th>Status</th>
                            <th>Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $user->orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <a href="<?php echo e(route('admin.orders.show', $order)); ?>" class="text-primary">
                                        <?php echo e($order->order_number); ?>

                                    </a>
                                </td>
                                <td>KSh <?php echo e(number_format($order->total, 2)); ?></td>
                                <td>
                                    <span class="badge badge-<?php echo e($order->status_badge['color']); ?>">
                                        <?php echo e($order->status_badge['label']); ?>

                                    </span>
                                </td>
                                <td><?php echo e($order->created_at->format('M d, Y')); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="4" class="text-muted text-center">No orders yet</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<style>
    .btn-warning {
        background: rgba(245, 158, 11, 0.2);
        color: var(--warning);
        border: 1px solid rgba(245, 158, 11, 0.3);
    }
    .btn-warning:hover {
        background: var(--warning);
        color: white;
    }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\shop\resources\views/admin/users/show.blade.php ENDPATH**/ ?>