<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'Onespot Solutions Shop')); ?></title>
    <meta name="description" content="Premium security equipment shop - CCTV cameras, access controls, smart locks, and more.">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:400,500,600,700,800&display=swap" rel="stylesheet" />
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" />

    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>

    <style>
        :root {
            --primary: #0ea5e9;
            --primary-dark: #0284c7;
            --secondary: #64748b;
            --success: #22c55e;
            --danger: #ef4444;
            --warning: #f59e0b;
            --dark: #0f172a;
            --darker: #020617;
        }

        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        body {
            font-family: 'Inter', sans-serif;
            background: var(--dark);
            color: #e2e8f0;
            line-height: 1.6;
        }

        a {
            color: inherit;
            text-decoration: none;
        }

        /* Navigation */
        .navbar {
            background: rgba(15, 23, 42, 0.95);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            position: sticky;
            top: 0;
            z-index: 1000;
        }

        .nav-container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 2rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
            height: 70px;
        }

        .logo {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            font-weight: 700;
            font-size: 1.25rem;
        }

        .logo i {
            font-size: 1.5rem;
            color: var(--primary);
        }

        .logo span {
            background: linear-gradient(90deg, #0ea5e9, #22c55e);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .nav-links {
            display: flex;
            align-items: center;
            gap: 2rem;
        }

        .nav-links a {
            color: #94a3b8;
            font-weight: 500;
            transition: color 0.2s;
        }

        .nav-links a:hover {
            color: var(--primary);
        }

        .nav-actions {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .cart-btn {
            position: relative;
            padding: 0.5rem 1rem;
            background: rgba(14, 165, 233, 0.1);
            border: 1px solid rgba(14, 165, 233, 0.3);
            border-radius: 8px;
            color: var(--primary);
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .cart-badge {
            position: absolute;
            top: -8px;
            right: -8px;
            background: var(--danger);
            color: white;
            font-size: 0.7rem;
            font-weight: 600;
            padding: 2px 6px;
            border-radius: 999px;
        }

        .btn {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.625rem 1.25rem;
            border-radius: 8px;
            font-weight: 500;
            font-size: 0.875rem;
            border: none;
            cursor: pointer;
            transition: all 0.2s;
        }

        .btn-primary {
            background: var(--primary);
            color: white;
        }

        .btn-primary:hover {
            background: var(--primary-dark);
            transform: translateY(-1px);
        }

        .btn-secondary {
            background: rgba(100, 116, 139, 0.2);
            color: #94a3b8;
            border: 1px solid rgba(100, 116, 139, 0.3);
        }

        /* Hero Section */
        .hero {
            background: linear-gradient(135deg, var(--darker) 0%, var(--dark) 50%, #0c1929 100%);
            padding: 6rem 2rem;
            position: relative;
            overflow: hidden;
        }

        .hero::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 600px;
            height: 600px;
            background: radial-gradient(circle, rgba(14, 165, 233, 0.15) 0%, transparent 70%);
        }

        .hero-container {
            max-width: 1400px;
            margin: 0 auto;
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 4rem;
            align-items: center;
        }

        .hero-content h1 {
            font-size: 3.5rem;
            font-weight: 800;
            line-height: 1.1;
            margin-bottom: 1.5rem;
        }

        .hero-content h1 span {
            background: linear-gradient(90deg, #0ea5e9, #22c55e);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .hero-content p {
            font-size: 1.125rem;
            color: #94a3b8;
            margin-bottom: 2rem;
            max-width: 500px;
        }

        .hero-features {
            display: flex;
            gap: 2rem;
            margin-top: 3rem;
        }

        .hero-feature {
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        .hero-feature i {
            color: var(--success);
        }

        .hero-feature span {
            color: #94a3b8;
            font-size: 0.9rem;
        }

        /* Hero Video/Slideshow Styles */
        .hero-video-container {
            width: 400px;
            height: 400px;
            max-width: 100%;
            aspect-ratio: 1/1;
            background: linear-gradient(135deg, rgba(14, 165, 233, 0.2), rgba(34, 197, 94, 0.2));
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            overflow: hidden;
            border: 3px solid rgba(14, 165, 233, 0.3);
            animation: pulse-border 3s ease-in-out infinite;
        }

        @media (max-width: 480px) {
            .hero-video-container {
                width: 300px;
                height: 300px;
            }
            .service-slide i {
                font-size: 4rem;
            }
        }

        @keyframes pulse-border {
            0%, 100% { border-color: rgba(14, 165, 233, 0.3); }
            50% { border-color: rgba(34, 197, 94, 0.5); }
        }

        .service-slide {
            position: absolute;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            opacity: 0;
            transform: scale(0.8);
            transition: all 0.8s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .service-slide.active {
            opacity: 1;
            transform: scale(1);
        }

        .service-slide i {
            font-size: 6rem;
            color: rgba(14, 165, 233, 0.7);
            margin-bottom: 1rem;
            animation: icon-glow 2s ease-in-out infinite;
        }

        @keyframes icon-glow {
            0%, 100% { filter: drop-shadow(0 0 10px rgba(14, 165, 233, 0.3)); }
            50% { filter: drop-shadow(0 0 25px rgba(14, 165, 233, 0.6)); }
        }

        .service-slide span {
            font-size: 1.25rem;
            font-weight: 600;
            color: #e2e8f0;
            text-transform: uppercase;
            letter-spacing: 2px;
        }

        .slide-indicators {
            position: absolute;
            bottom: 30px;
            display: flex;
            gap: 8px;
        }

        .indicator {
            width: 10px;
            height: 10px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.3);
            cursor: pointer;
            transition: all 0.3s;
        }

        .indicator.active {
            background: var(--primary);
            transform: scale(1.2);
        }

        .indicator:hover {
            background: rgba(14, 165, 233, 0.6);
        }

        /* Categories Section */
        .section {
            padding: 5rem 2rem;
            max-width: 1400px;
            margin: 0 auto;
        }

        .section-header {
            text-align: center;
            margin-bottom: 3rem;
        }

        .section-header h2 {
            font-size: 2.25rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
        }

        .section-header p {
            color: #64748b;
        }

        .categories-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1.5rem;
        }

        .category-card {
            background: linear-gradient(135deg, rgba(30, 41, 59, 0.8) 0%, rgba(15, 23, 42, 0.8) 100%);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 16px;
            padding: 2rem;
            text-align: center;
            transition: all 0.3s;
            cursor: pointer;
        }

        .category-card:hover {
            transform: translateY(-5px);
            border-color: rgba(14, 165, 233, 0.5);
            box-shadow: 0 20px 40px -15px rgba(14, 165, 233, 0.2);
        }

        .category-card i {
            font-size: 2.5rem;
            color: var(--primary);
            margin-bottom: 1rem;
        }

        .category-card h3 {
            font-size: 1rem;
            font-weight: 600;
            margin-bottom: 0.25rem;
        }

        .category-card span {
            color: #64748b;
            font-size: 0.85rem;
        }

        /* Products Grid */
        .products-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
            gap: 1.5rem;
        }

        .product-card {
            background: rgba(30, 41, 59, 0.6);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 16px;
            overflow: hidden;
            transition: all 0.3s;
        }

        .product-card:hover {
            transform: translateY(-5px);
            border-color: rgba(14, 165, 233, 0.3);
            box-shadow: 0 20px 40px -15px rgba(0, 0, 0, 0.5);
        }

        .product-image {
            aspect-ratio: 4/3;
            background: rgba(15, 23, 42, 0.8);
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
        }

        .product-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .product-image i {
            font-size: 3rem;
            color: #475569;
        }

        .product-badge {
            position: absolute;
            top: 1rem;
            left: 1rem;
            background: var(--danger);
            color: white;
            padding: 0.25rem 0.75rem;
            border-radius: 999px;
            font-size: 0.75rem;
            font-weight: 600;
        }

        .product-content {
            padding: 1.25rem;
        }

        .product-category {
            color: var(--primary);
            font-size: 0.8rem;
            font-weight: 500;
            margin-bottom: 0.5rem;
        }

        .product-title {
            font-size: 1rem;
            font-weight: 600;
            margin-bottom: 0.5rem;
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }

        .product-price {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            margin-bottom: 1rem;
        }

        .product-price .current {
            font-size: 1.25rem;
            font-weight: 700;
            color: var(--success);
        }

        .product-price .original {
            color: #64748b;
            text-decoration: line-through;
            font-size: 0.9rem;
        }

        .product-actions {
            display: flex;
            gap: 0.5rem;
        }

        .product-actions .btn {
            flex: 1;
            justify-content: center;
        }

        /* CTA Section */
        .cta {
            background: linear-gradient(135deg, rgba(14, 165, 233, 0.1) 0%, rgba(34, 197, 94, 0.1) 100%);
            border: 1px solid rgba(14, 165, 233, 0.2);
            border-radius: 20px;
            padding: 4rem;
            text-align: center;
            margin: 3rem 0;
        }

        .cta h2 {
            font-size: 2rem;
            margin-bottom: 1rem;
        }

        .cta p {
            color: #94a3b8;
            margin-bottom: 2rem;
            max-width: 600px;
            margin-left: auto;
            margin-right: auto;
        }

        .cta .highlight {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            background: rgba(34, 197, 94, 0.2);
            color: var(--success);
            padding: 0.5rem 1rem;
            border-radius: 999px;
            font-weight: 600;
            margin-bottom: 1rem;
        }

        /* Footer */
        footer {
            background: var(--darker);
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            padding: 4rem 2rem 2rem;
        }

        .footer-container {
            max-width: 1400px;
            margin: 0 auto;
            display: grid;
            grid-template-columns: 2fr repeat(3, 1fr);
            gap: 3rem;
        }

        .footer-brand h3 {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            margin-bottom: 1rem;
        }

        .footer-brand p {
            color: #64748b;
            font-size: 0.9rem;
            margin-bottom: 1.5rem;
        }

        .footer-section h4 {
            font-size: 0.9rem;
            font-weight: 600;
            margin-bottom: 1rem;
            color: #94a3b8;
        }

        .footer-section ul {
            list-style: none;
        }

        .footer-section li {
            margin-bottom: 0.5rem;
        }

        .footer-section a {
            color: #64748b;
            font-size: 0.9rem;
            transition: color 0.2s;
        }

        .footer-section a:hover {
            color: var(--primary);
        }

        .footer-bottom {
            max-width: 1400px;
            margin: 3rem auto 0;
            padding-top: 2rem;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            text-align: center;
            color: #475569;
            font-size: 0.85rem;
        }

        @media (max-width: 1024px) {
            .hero-container {
                grid-template-columns: 1fr;
                text-align: center;
            }
            .hero-content h1 {
                font-size: 2.5rem;
            }
            .hero-features {
                justify-content: center;
            }
            .footer-container {
                grid-template-columns: 1fr 1fr;
            }
        }

        @media (max-width: 768px) {
            .nav-links {
                display: none;
            }
            .hero-content h1 {
                font-size: 2rem;
            }
            .hero-features {
                flex-direction: column;
                align-items: center;
            }
            .footer-container {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar">
        <div class="nav-container">
            <a href="<?php echo e(route('shop.home')); ?>" class="logo">
                <i class="fas fa-shield-halved"></i>
                <span>Onespot Solutions</span>
            </a>

            <div class="nav-links">
                <a href="<?php echo e(route('shop.home')); ?>">Home</a>
                <a href="<?php echo e(route('shop.products')); ?>">Products</a>
                <a href="<?php echo e(route('shop.categories')); ?>">Categories</a>
                <a href="<?php echo e(route('shop.installation')); ?>">Installation</a>
                <a href="<?php echo e(route('shop.contact')); ?>">Contact</a>
            </div>

            <div class="nav-actions">
                <a href="#" class="cart-btn">
                    <i class="fas fa-shopping-cart"></i>
                    <span>Cart</span>
                    <span class="cart-badge">0</span>
                </a>
                <?php if(auth()->guard()->check()): ?>
                    <?php if(auth()->user()->isAdmin()): ?>
                        <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-secondary">Admin</a>
                    <?php else: ?>
                        <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-secondary">My Account</a>
                    <?php endif; ?>
                <?php else: ?>
                    <a href="<?php echo e(route('login')); ?>" class="btn btn-secondary">Login</a>
                    <a href="<?php echo e(route('register')); ?>" class="btn btn-primary">Register</a>
                <?php endif; ?>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero">
        <div class="hero-container">
            <div class="hero-content">
                <h1>Secure Your World with <span>Premium Security</span> Equipment</h1>
                <p>From CCTV cameras to smart access controls, we provide cutting-edge security solutions for homes and businesses. Professional installation available.</p>
                
                <div style="display: flex; gap: 1rem;">
                    <a href="#products" class="btn btn-primary" style="padding: 1rem 2rem;">
                        <i class="fas fa-shopping-bag"></i> Shop Now
                    </a>
                    <a href="<?php echo e(route('shop.contact')); ?>" class="btn btn-secondary" style="padding: 1rem 2rem;">
                        <i class="fas fa-file-invoice"></i> Request Quote
                    </a>
                </div>

                <div class="hero-features">
                    <div class="hero-feature">
                        <i class="fas fa-check-circle"></i>
                        <span>Free Delivery Over KSh 10,000</span>
                    </div>
                    <div class="hero-feature">
                        <i class="fas fa-check-circle"></i>
                        <span>10% Off Installation</span>
                    </div>
                    <div class="hero-feature">
                        <i class="fas fa-check-circle"></i>
                        <span>Expert Support</span>
                    </div>
                </div>
            </div>

            <div class="hero-image" style="display: flex; justify-content: center;">
                <div class="hero-video-container">
                    <div class="service-slide active" data-service="0">
                        <i class="fas fa-video"></i>
                        <span>CCTV Cameras</span>
                    </div>
                    <div class="service-slide" data-service="1">
                        <i class="fas fa-fingerprint"></i>
                        <span>Access Control</span>
                    </div>
                    <div class="service-slide" data-service="2">
                        <i class="fas fa-lock"></i>
                        <span>Smart Locks</span>
                    </div>
                    <div class="service-slide" data-service="3">
                        <i class="fas fa-bolt"></i>
                        <span>Electric Fencing</span>
                    </div>
                    <div class="service-slide" data-service="4">
                        <i class="fas fa-network-wired"></i>
                        <span>Networking</span>
                    </div>
                    <div class="slide-indicators">
                        <span class="indicator active" data-index="0"></span>
                        <span class="indicator" data-index="1"></span>
                        <span class="indicator" data-index="2"></span>
                        <span class="indicator" data-index="3"></span>
                        <span class="indicator" data-index="4"></span>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Categories Section -->
    <section class="section">
        <div class="section-header">
            <h2>Shop by Category</h2>
            <p>Browse our wide range of security and networking equipment</p>
        </div>

        <div class="categories-grid">
            <a href="#" class="category-card">
                <i class="fas fa-video"></i>
                <h3>CCTV Cameras</h3>
                <span>50+ Products</span>
            </a>
            <a href="#" class="category-card">
                <i class="fas fa-fingerprint"></i>
                <h3>Access Control</h3>
                <span>30+ Products</span>
            </a>
            <a href="#" class="category-card">
                <i class="fas fa-lock"></i>
                <h3>Smart Locks</h3>
                <span>25+ Products</span>
            </a>
            <a href="#" class="category-card">
                <i class="fas fa-bolt"></i>
                <h3>Electric Fencing</h3>
                <span>15+ Products</span>
            </a>
            <a href="#" class="category-card">
                <i class="fas fa-road-barrier"></i>
                <h3>Barrier Gates</h3>
                <span>20+ Products</span>
            </a>
            <a href="#" class="category-card">
                <i class="fas fa-network-wired"></i>
                <h3>Networking</h3>
                <span>40+ Products</span>
            </a>
        </div>
    </section>

    <!-- Featured Products -->
    <section class="section" id="products">
        <div class="section-header">
            <h2>Featured Products</h2>
            <p>Our best-selling security equipment</p>
        </div>

        <div class="products-grid">
            <?php $__empty_1 = true; $__currentLoopData = $featuredProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="product-card">
                    <div class="product-image">
                        <?php if($product->images->count() > 0): ?>
                            <img src="<?php echo e(Storage::url($product->images->first()->path)); ?>" alt="<?php echo e($product->name); ?>">
                        <?php else: ?>
                            <i class="fas fa-box"></i>
                        <?php endif; ?>
                        <?php if($product->is_on_sale): ?>
                            <span class="product-badge">-<?php echo e($product->discount_percentage); ?>%</span>
                        <?php elseif($product->created_at->diffInDays(now()) < 7): ?>
                            <span class="product-badge" style="background: var(--success);">New</span>
                        <?php endif; ?>
                    </div>
                    <div class="product-content">
                        <div class="product-category"><?php echo e($product->category->name ?? 'Uncategorized'); ?></div>
                        <h3 class="product-title"><?php echo e($product->name); ?></h3>
                        <div class="product-price">
                            <span class="current">KSh <?php echo e(number_format($product->effective_price)); ?></span>
                            <?php if($product->is_on_sale): ?>
                                <span class="original">KSh <?php echo e(number_format($product->price)); ?></span>
                            <?php endif; ?>
                        </div>
                        <div class="product-actions">
                            <?php if(auth()->guard()->check()): ?>
                                <form action="<?php echo e(route('cart.add')); ?>" method="POST" style="flex: 1;">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                                    <input type="hidden" name="quantity" value="1">
                                    <button type="submit" class="btn btn-primary" style="width: 100%;" <?php echo e(!$product->in_stock ? 'disabled' : ''); ?>>
                                        <?php echo e($product->in_stock ? 'Add to Cart' : 'Out of Stock'); ?>

                                    </button>
                                </form>
                            <?php else: ?>
                                <a href="<?php echo e(route('login')); ?>" class="btn btn-primary" style="flex: 1; justify-content: center;">Add to Cart</a>
                            <?php endif; ?>
                            <a href="<?php echo e(route('shop.product', $product)); ?>" class="btn btn-secondary"><i class="fas fa-eye"></i></a>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div style="grid-column: 1/-1; text-align: center; padding: 3rem;">
                    <i class="fas fa-box-open" style="font-size: 3rem; color: #475569; margin-bottom: 1rem; display: block;"></i>
                    <p style="color: #64748b;">No products available yet. Check back soon!</p>
                </div>
            <?php endif; ?>
        </div>

        <div style="text-align: center; margin-top: 2rem;">
            <a href="<?php echo e(route('shop.products')); ?>" class="btn btn-secondary" style="padding: 1rem 2rem;">
                View All Products <i class="fas fa-arrow-right"></i>
            </a>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="section">
        <div class="cta">
            <div class="highlight">
                <i class="fas fa-percent"></i>
                <span>10% OFF Installation</span>
            </div>
            <h2>Need Professional Installation?</h2>
            <p>Buy your equipment from our shop and get 10% discount on professional installation services. Our certified technicians ensure your security system is set up correctly.</p>
            <a href="<?php echo e(route('shop.contact')); ?>" class="btn btn-primary" style="padding: 1rem 2rem;">
                <i class="fas fa-file-invoice"></i> Request Installation Quote
            </a>
        </div>
    </section>

    <!-- Footer -->
    <footer>
        <div class="footer-container">
            <div class="footer-brand">
                <h3>
                    <i class="fas fa-shield-halved" style="color: var(--primary);"></i>
                    Onespot Solutions
                </h3>
                <p>Your trusted partner for security equipment and installation services. We provide premium quality products with expert support.</p>
                <div style="display: flex; gap: 1rem;">
                    <a href="#" style="color: #64748b;"><i class="fab fa-facebook" style="font-size: 1.25rem;"></i></a>
                    <a href="#" style="color: #64748b;"><i class="fab fa-twitter" style="font-size: 1.25rem;"></i></a>
                    <a href="#" style="color: #64748b;"><i class="fab fa-instagram" style="font-size: 1.25rem;"></i></a>
                </div>
            </div>

            <div class="footer-section">
                <h4>Products</h4>
                <ul>
                    <li><a href="<?php echo e(route('shop.products')); ?>">CCTV Cameras</a></li>
                    <li><a href="<?php echo e(route('shop.products')); ?>">Access Control</a></li>
                    <li><a href="<?php echo e(route('shop.products')); ?>">Smart Locks</a></li>
                    <li><a href="<?php echo e(route('shop.products')); ?>">Electric Fencing</a></li>
                    <li><a href="<?php echo e(route('shop.products')); ?>">Networking</a></li>
                </ul>
            </div>

            <div class="footer-section">
                <h4>Services</h4>
                <ul>
                    <li><a href="<?php echo e(route('shop.installation')); ?>">Installation</a></li>
                    <li><a href="<?php echo e(route('shop.installation')); ?>">Maintenance</a></li>
                    <li><a href="<?php echo e(route('shop.installation')); ?>">Consultation</a></li>
                    <li><a href="<?php echo e(route('shop.contact')); ?>">Request Quote</a></li>
                </ul>
            </div>

            <div class="footer-section">
                <h4>Contact</h4>
                <ul>
                    <li><a href="tel:+254743456809"><i class="fas fa-phone"></i> +254 743 456 809</a></li>
                    <li><a href="mailto:info@onespotsolutions.co.ke"><i class="fas fa-envelope"></i> info@onespotsolutions.co.ke</a></li>
                    <li><a href="<?php echo e(route('shop.contact')); ?>"><i class="fas fa-map-marker-alt"></i> Nairobi, Kenya</a></li>
                </ul>
            </div>
        </div>

        <div class="footer-bottom">
            <p>&copy; <?php echo e(date('Y')); ?> One Spot Solutions. All rights reserved.</p>
        </div>
    </footer>

    <script>
        // Hero Services Slideshow
        document.addEventListener('DOMContentLoaded', function() {
            const slides = document.querySelectorAll('.service-slide');
            const indicators = document.querySelectorAll('.indicator');
            let currentSlide = 0;
            const totalSlides = slides.length;

            function showSlide(index) {
                slides.forEach(slide => slide.classList.remove('active'));
                indicators.forEach(ind => ind.classList.remove('active'));
                
                slides[index].classList.add('active');
                indicators[index].classList.add('active');
                currentSlide = index;
            }

            function nextSlide() {
                const next = (currentSlide + 1) % totalSlides;
                showSlide(next);
            }

            // Auto-advance every 3 seconds
            setInterval(nextSlide, 3000);

            // Click on indicators to jump to slide
            indicators.forEach((indicator, index) => {
                indicator.addEventListener('click', () => showSlide(index));
            });
        });
    </script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\shop\resources\views/shop/home.blade.php ENDPATH**/ ?>