<?php

namespace App\Services;

use App\Models\Order;
use Barryvdh\DomPDF\Facade\Pdf;

class InvoiceService
{
    /**
     * Generate PDF invoice for an order.
     *
     * @param Order $order
     * @return \Barryvdh\DomPDF\PDF
     */
    public function generate(Order $order)
    {
        $data = [
            'order' => $order,
            'company' => [
                'name' => 'OneSpot Solutions Ltd',
                'address' => 'Nairobi, Kenya',
                'phone' => '+254 740 940 303',
                'email' => 'info@onespotsolutionsltd.co.ke',
                'website' => 'www.onespotsolutionsltd.co.ke',
            ]
        ];

        $pdf = Pdf::loadView('invoices.order', $data);
        
        return $pdf;
    }
}
