<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('order_id')->constrained()->onDelete('cascade');
            $table->string('payment_method'); // mpesa, bank
            $table->string('transaction_id')->nullable();
            $table->string('merchant_request_id')->nullable(); // M-Pesa specific
            $table->string('checkout_request_id')->nullable(); // M-Pesa specific
            $table->decimal('amount', 12, 2);
            $table->string('phone_number')->nullable(); // For M-Pesa
            $table->string('bank_reference')->nullable(); // For bank payments
            $table->string('status')->default('pending'); // pending, completed, failed, cancelled
            $table->json('response_data')->nullable(); // Store full API response
            $table->text('failure_reason')->nullable();
            $table->timestamp('paid_at')->nullable();
            $table->timestamps();

            $table->index(['order_id', 'status']);
            $table->index('transaction_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payments');
    }
};
