<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('quotations', function (Blueprint $table) {
            $table->id();
            $table->string('quotation_number')->unique();
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('set null');
            $table->string('status')->default('draft'); // draft, sent, accepted, rejected, expired
            
            // Customer details
            $table->string('customer_name');
            $table->string('customer_email');
            $table->string('customer_phone');
            $table->text('customer_address')->nullable();
            
            // Service details
            $table->string('service_type')->nullable(); // installation, maintenance, consultation
            $table->text('service_description')->nullable();
            $table->text('site_address')->nullable();
            
            // Totals
            $table->decimal('products_total', 12, 2)->default(0);
            $table->decimal('installation_total', 12, 2)->default(0);
            $table->decimal('installation_discount', 12, 2)->default(0); // The 10% discount for shop customers
            $table->decimal('discount_percentage', 5, 2)->default(10); // Adjustable discount rate
            $table->decimal('total', 12, 2);
            
            // Validity
            $table->date('valid_until')->nullable();
            $table->text('terms_conditions')->nullable();
            $table->text('notes')->nullable();
            
            $table->boolean('is_shop_customer')->default(false); // Did they buy from shop?
            $table->timestamps();
            $table->softDeletes();

            $table->index(['user_id', 'status']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('quotations');
    }
};
