<?php

namespace Database\Seeders;

use App\Models\Setting;
use Illuminate\Database\Seeder;

class SettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $settings = [
            // Company Information
            [
                'key' => 'company_name',
                'value' => 'One Spot Solutions',
                'type' => 'string',
                'group' => 'company',
                'label' => 'Company Name',
                'description' => 'Your company name displayed on invoices and quotations',
            ],
            [
                'key' => 'company_email',
                'value' => 'info@onespotsolutionsltd.co.ke',
                'type' => 'string',
                'group' => 'company',
                'label' => 'Company Email',
                'description' => 'Main contact email address',
            ],
            [
                'key' => 'company_phone',
                'value' => '+254743456809',
                'type' => 'string',
                'group' => 'company',
                'label' => 'Company Phone',
                'description' => 'Main contact phone number',
            ],
            [
                'key' => 'company_address',
                'value' => 'Nairobi, Kenya',
                'type' => 'string',
                'group' => 'company',
                'label' => 'Company Address',
                'description' => 'Physical business address',
            ],
            [
                'key' => 'company_logo',
                'value' => null,
                'type' => 'string',
                'group' => 'company',
                'label' => 'Company Logo',
                'description' => 'Logo displayed on website and documents',
            ],

            // Discount Settings
            [
                'key' => 'installation_discount',
                'value' => '10',
                'type' => 'number',
                'group' => 'discount',
                'label' => 'Installation Discount (%)',
                'description' => 'Discount on installation services for customers who buy equipment from the shop',
            ],
            [
                'key' => 'enable_installation_discount',
                'value' => 'true',
                'type' => 'boolean',
                'group' => 'discount',
                'label' => 'Enable Installation Discount',
                'description' => 'Whether to apply automatic discount on installation for shop customers',
            ],

            // M-Pesa Payment Settings
            [
                'key' => 'mpesa_enabled',
                'value' => 'true',
                'type' => 'boolean',
                'group' => 'payment',
                'label' => 'Enable M-Pesa',
                'description' => 'Allow M-Pesa payments',
            ],
            [
                'key' => 'mpesa_till_number',
                'value' => '',
                'type' => 'string',
                'group' => 'payment',
                'label' => 'M-Pesa Till Number',
                'description' => 'Your M-Pesa Buy Goods Till Number',
            ],
            [
                'key' => 'mpesa_consumer_key',
                'value' => '',
                'type' => 'string',
                'group' => 'payment',
                'label' => 'M-Pesa Consumer Key',
                'description' => 'Daraja API Consumer Key',
            ],
            [
                'key' => 'mpesa_consumer_secret',
                'value' => '',
                'type' => 'string',
                'group' => 'payment',
                'label' => 'M-Pesa Consumer Secret',
                'description' => 'Daraja API Consumer Secret',
            ],
            [
                'key' => 'mpesa_passkey',
                'value' => '',
                'type' => 'string',
                'group' => 'payment',
                'label' => 'M-Pesa Passkey',
                'description' => 'Daraja API Passkey for STK Push',
            ],
            [
                'key' => 'mpesa_environment',
                'value' => 'sandbox',
                'type' => 'string',
                'group' => 'payment',
                'label' => 'M-Pesa Environment',
                'description' => 'sandbox or production',
            ],

            // Bank Payment Settings
            [
                'key' => 'bank_enabled',
                'value' => 'true',
                'type' => 'boolean',
                'group' => 'payment',
                'label' => 'Enable Bank Payment',
                'description' => 'Allow bank transfer payments',
            ],
            [
                'key' => 'bank_name',
                'value' => '',
                'type' => 'string',
                'group' => 'payment',
                'label' => 'Bank Name',
                'description' => 'Name of your bank',
            ],
            [
                'key' => 'bank_account_name',
                'value' => 'One Spot Solutions',
                'type' => 'string',
                'group' => 'payment',
                'label' => 'Bank Account Name',
                'description' => 'Name on the bank account',
            ],
            [
                'key' => 'bank_account_number',
                'value' => '',
                'type' => 'string',
                'group' => 'payment',
                'label' => 'Bank Account Number',
                'description' => 'Your bank account number',
            ],
            [
                'key' => 'bank_branch',
                'value' => '',
                'type' => 'string',
                'group' => 'payment',
                'label' => 'Bank Branch',
                'description' => 'Bank branch name',
            ],

            // General Settings
            [
                'key' => 'currency',
                'value' => 'KES',
                'type' => 'string',
                'group' => 'general',
                'label' => 'Currency',
                'description' => 'Default currency for prices',
            ],
            [
                'key' => 'currency_symbol',
                'value' => 'KSh',
                'type' => 'string',
                'group' => 'general',
                'label' => 'Currency Symbol',
                'description' => 'Currency symbol displayed with prices',
            ],
            [
                'key' => 'quotation_validity_days',
                'value' => '30',
                'type' => 'number',
                'group' => 'general',
                'label' => 'Quotation Validity (Days)',
                'description' => 'Number of days a quotation remains valid',
            ],
            [
                'key' => 'default_terms',
                'value' => "1. Prices are valid for the period specified.\n2. 50% deposit required upon confirmation.\n3. Balance payable upon completion.\n4. Warranty as per manufacturer terms.",
                'type' => 'string',
                'group' => 'general',
                'label' => 'Default Terms & Conditions',
                'description' => 'Default terms for quotations',
            ],
        ];

        foreach ($settings as $setting) {
            Setting::create($setting);
        }
    }
}
