@extends('admin.layouts.app')

@section('title', 'Add Category')

@section('content')
<div class="card" style="max-width: 600px;">
    <div class="card-header">
        <h3 class="card-title">Add New Category</h3>
    </div>

    <form method="POST" action="{{ route('admin.categories.store') }}" enctype="multipart/form-data">
        @csrf

        <div class="form-group">
            <label class="form-label">Category Name *</label>
            <input type="text" name="name" class="form-input" value="{{ old('name') }}" required>
        </div>

        <div class="form-group">
            <label class="form-label">Parent Category</label>
            <select name="parent_id" class="form-select">
                <option value="">None (Top-level category)</option>
                @foreach($parentCategories as $parent)
                    <option value="{{ $parent->id }}" {{ old('parent_id') == $parent->id ? 'selected' : '' }}>
                        {{ $parent->name }}
                    </option>
                @endforeach
            </select>
            <small class="text-muted">Leave empty for a main category, or select a parent to create a subcategory.</small>
        </div>

        <div class="form-group">
            <label class="form-label">Description</label>
            <textarea name="description" class="form-textarea" rows="3">{{ old('description') }}</textarea>
        </div>

        <div class="form-group">
            <label class="form-label">Category Image</label>
            <input type="file" name="image" class="form-input" accept="image/*">
        </div>

        <div class="form-group">
            <label class="flex items-center gap-2">
                <input type="checkbox" name="is_active" value="1" {{ old('is_active', true) ? 'checked' : '' }}>
                <span>Active</span>
            </label>
        </div>

        <div class="flex gap-3">
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-save"></i> Create Category
            </button>
            <a href="{{ route('admin.categories.index') }}" class="btn btn-secondary">Cancel</a>
        </div>
    </form>
</div>
@endsection
