@extends('admin.layouts.app')

@section('title', 'Products')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title">All Products</h3>
        <a href="{{ route('admin.products.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> Add Product
        </a>
    </div>

    <!-- Filters -->
    <form method="GET" class="mb-3">
        <div class="flex gap-3 items-center">
            <input type="text" name="search" class="form-input" placeholder="Search products..." 
                   value="{{ request('search') }}" style="max-width: 300px;">
            
            <select name="category" class="form-select" style="max-width: 200px;">
                <option value="">All Categories</option>
                @foreach($categories as $category)
                    <option value="{{ $category->id }}" {{ request('category') == $category->id ? 'selected' : '' }}>
                        {{ $category->name }}
                    </option>
                    @foreach($category->children as $child)
                        <option value="{{ $child->id }}" {{ request('category') == $child->id ? 'selected' : '' }}>
                            &nbsp;&nbsp;└ {{ $child->name }}
                        </option>
                    @endforeach
                @endforeach
            </select>

            <select name="status" class="form-select" style="max-width: 150px;">
                <option value="">All Status</option>
                <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Active</option>
                <option value="inactive" {{ request('status') == 'inactive' ? 'selected' : '' }}>Inactive</option>
                <option value="out_of_stock" {{ request('status') == 'out_of_stock' ? 'selected' : '' }}>Out of Stock</option>
            </select>

            <button type="submit" class="btn btn-primary">
                <i class="fas fa-search"></i> Filter
            </button>
            
            @if(request()->hasAny(['search', 'category', 'status']))
                <a href="{{ route('admin.products.index') }}" class="btn btn-secondary">Clear</a>
            @endif
        </div>
    </form>

    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th>Image</th>
                    <th>Product</th>
                    <th>Category</th>
                    <th>Price</th>
                    <th>Stock</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($products as $product)
                <tr>
                    <td>
                        @if($product->primaryImage)
                            <img src="{{ asset('storage/' . $product->primaryImage->path) }}" 
                                 alt="{{ $product->name }}" 
                                 style="width: 50px; height: 50px; object-fit: cover; border-radius: 8px;">
                        @else
                            <div style="width: 50px; height: 50px; background: rgba(100,116,139,0.3); border-radius: 8px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-image text-muted"></i>
                            </div>
                        @endif
                    </td>
                    <td>
                        <div>
                            <strong>{{ Str::limit($product->name, 40) }}</strong>
                            <div class="text-muted" style="font-size: 0.8rem;">SKU: {{ $product->sku }}</div>
                        </div>
                    </td>
                    <td>{{ $product->category->name ?? '-' }}</td>
                    <td>
                        @if($product->sale_price)
                            <span class="text-muted" style="text-decoration: line-through;">KSh {{ number_format($product->price, 2) }}</span>
                            <br>
                            <span class="text-success">KSh {{ number_format($product->sale_price, 2) }}</span>
                        @else
                            KSh {{ number_format($product->price, 2) }}
                        @endif
                    </td>
                    <td>
                        @if($product->stock_quantity == 0)
                            <span class="badge badge-danger">Out of Stock</span>
                        @elseif($product->stock_quantity < 5)
                            <span class="badge badge-warning">{{ $product->stock_quantity }} left</span>
                        @else
                            <span class="badge badge-success">{{ $product->stock_quantity }} in stock</span>
                        @endif
                    </td>
                    <td>
                        @if($product->is_active)
                            <span class="badge badge-success">Active</span>
                        @else
                            <span class="badge badge-secondary">Inactive</span>
                        @endif
                        @if($product->is_featured)
                            <span class="badge badge-primary">Featured</span>
                        @endif
                    </td>
                    <td>
                        <div class="flex gap-2">
                            <a href="{{ route('admin.products.edit', $product) }}" class="btn btn-secondary btn-sm">
                                <i class="fas fa-edit"></i>
                            </a>
                            <form method="POST" action="{{ route('admin.products.destroy', $product) }}" 
                                  onsubmit="return confirm('Are you sure you want to delete this product?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger btn-sm">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="7" class="text-muted" style="text-align: center; padding: 3rem;">
                        <i class="fas fa-box" style="font-size: 2rem; margin-bottom: 1rem; display: block;"></i>
                        No products found. <a href="{{ route('admin.products.create') }}" class="text-primary">Add your first product</a>
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    {{ $products->links() }}
</div>
@endsection
