@extends('admin.layouts.app')

@section('title', 'Edit Quotation')

@section('content')
<form method="POST" action="{{ route('admin.quotations.update', $quotation) }}" id="quotationForm">
    @csrf
    @method('PUT')

    <div class="grid grid-2">
        <!-- Customer Info -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Customer Information</h3>
            </div>

            <div class="form-group">
                <label class="form-label">Customer Name *</label>
                <input type="text" name="customer_name" class="form-input" value="{{ old('customer_name', $quotation->customer_name) }}" required>
            </div>

            <div class="grid grid-2">
                <div class="form-group">
                    <label class="form-label">Email *</label>
                    <input type="email" name="customer_email" class="form-input" value="{{ old('customer_email', $quotation->customer_email) }}" required>
                </div>
                <div class="form-group">
                    <label class="form-label">Phone *</label>
                    <input type="tel" name="customer_phone" class="form-input" value="{{ old('customer_phone', $quotation->customer_phone) }}" required>
                </div>
            </div>

            <div class="form-group">
                <label class="form-label">Address</label>
                <textarea name="customer_address" class="form-textarea" rows="2">{{ old('customer_address', $quotation->customer_address) }}</textarea>
            </div>

            <div class="form-group">
                <label class="form-label">Installation Site Address</label>
                <textarea name="site_address" class="form-textarea" rows="2">{{ old('site_address', $quotation->site_address) }}</textarea>
            </div>
        </div>

        <!-- Quotation Settings -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Quotation Settings</h3>
            </div>

            <div class="form-group">
                <label class="form-label">Status</label>
                <select name="status" class="form-select">
                    <option value="draft" {{ $quotation->status === 'draft' ? 'selected' : '' }}>Draft</option>
                    <option value="sent" {{ $quotation->status === 'sent' ? 'selected' : '' }}>Sent</option>
                    <option value="accepted" {{ $quotation->status === 'accepted' ? 'selected' : '' }}>Accepted</option>
                    <option value="rejected" {{ $quotation->status === 'rejected' ? 'selected' : '' }}>Rejected</option>
                    <option value="expired" {{ $quotation->status === 'expired' ? 'selected' : '' }}>Expired</option>
                </select>
            </div>

            <div class="form-group">
                <label class="form-label">Service Type</label>
                <select name="service_type" class="form-select">
                    <option value="installation" {{ old('service_type', $quotation->service_type) == 'installation' ? 'selected' : '' }}>Installation</option>
                    <option value="maintenance" {{ old('service_type', $quotation->service_type) == 'maintenance' ? 'selected' : '' }}>Maintenance</option>
                    <option value="consultation" {{ old('service_type', $quotation->service_type) == 'consultation' ? 'selected' : '' }}>Consultation</option>
                    <option value="product_sale" {{ old('service_type', $quotation->service_type) == 'product_sale' ? 'selected' : '' }}>Product Sale</option>
                </select>
            </div>

            <div class="form-group">
                <label class="form-label">Service Description</label>
                <textarea name="service_description" class="form-textarea" rows="3">{{ old('service_description', $quotation->service_description) }}</textarea>
            </div>

            <div class="form-group">
                <label class="form-label">Valid Until</label>
                <input type="date" name="valid_until" class="form-input" value="{{ old('valid_until', $quotation->valid_until ? $quotation->valid_until->format('Y-m-d') : '') }}">
            </div>

            <div class="form-group">
                <label class="flex items-center gap-2">
                    <input type="checkbox" name="is_shop_customer" value="1" id="shopCustomer" {{ old('is_shop_customer', $quotation->is_shop_customer) ? 'checked' : '' }}>
                    <span>Customer bought equipment from our shop (apply installation discount)</span>
                </label>
            </div>

            <div class="form-group">
                <label class="form-label">Discount Percentage (%)</label>
                <input type="number" name="discount_percentage" class="form-input" value="{{ old('discount_percentage', $quotation->discount_percentage) }}" min="0" max="100" step="0.5">
            </div>
        </div>
    </div>

    <!-- Quotation Items -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Quotation Items</h3>
        </div>

        <div id="itemsContainer">
            @foreach($quotation->items as $index => $item)
            <div class="item-row flex gap-3 mb-2" data-index="{{ $index }}">
                <select name="items[{{ $index }}][item_type]" class="form-select" style="width: 120px;">
                    <option value="product" {{ $item->item_type === 'product' ? 'selected' : '' }}>Product</option>
                    <option value="service" {{ $item->item_type === 'service' ? 'selected' : '' }}>Service</option>
                    <option value="labor" {{ $item->item_type === 'labor' ? 'selected' : '' }}>Labor</option>
                </select>
                <input type="text" name="items[{{ $index }}][description]" class="form-input" placeholder="Description" value="{{ $item->description }}" required style="flex: 2;">
                <input type="number" name="items[{{ $index }}][unit_price]" class="form-input" placeholder="Unit Price" value="{{ $item->unit_price }}" step="0.01" min="0" required style="width: 150px;">
                <input type="number" name="items[{{ $index }}][quantity]" class="form-input" placeholder="Qty" value="{{ $item->quantity }}" min="1" required style="width: 80px;">
                <button type="button" class="btn btn-danger btn-sm remove-item"><i class="fas fa-times"></i></button>
            </div>
            @endforeach
        </div>

        <button type="button" id="addItem" class="btn btn-secondary btn-sm mt-2">
            <i class="fas fa-plus"></i> Add Item
        </button>
    </div>

    <!-- Notes -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Additional Notes</h3>
        </div>
        <textarea name="notes" class="form-textarea" rows="3" placeholder="Any additional notes for this quotation...">{{ old('notes', $quotation->notes) }}</textarea>
    </div>

    <div class="flex gap-3">
        <button type="submit" class="btn btn-primary">
            <i class="fas fa-save"></i> Update Quotation
        </button>
        <a href="{{ route('admin.quotations.index') }}" class="btn btn-secondary">Cancel</a>
    </div>
</form>

@push('scripts')
<script>
    let itemIndex = {{ $quotation->items->count() }};
    
    document.getElementById('addItem').addEventListener('click', function() {
        const container = document.getElementById('itemsContainer');
        const row = document.createElement('div');
        row.className = 'item-row flex gap-3 mb-2';
        row.dataset.index = itemIndex;
        row.innerHTML = `
            <select name="items[${itemIndex}][item_type]" class="form-select" style="width: 120px;">
                <option value="product">Product</option>
                <option value="service">Service</option>
                <option value="labor">Labor</option>
            </select>
            <input type="text" name="items[${itemIndex}][description]" class="form-input" placeholder="Description" required style="flex: 2;">
            <input type="number" name="items[${itemIndex}][unit_price]" class="form-input" placeholder="Unit Price" step="0.01" min="0" required style="width: 150px;">
            <input type="number" name="items[${itemIndex}][quantity]" class="form-input" placeholder="Qty" min="1" value="1" required style="width: 80px;">
            <button type="button" class="btn btn-danger btn-sm remove-item"><i class="fas fa-times"></i></button>
        `;
        container.appendChild(row);
        itemIndex++;
        updateRemoveButtons();
    });

    document.getElementById('itemsContainer').addEventListener('click', function(e) {
        if (e.target.closest('.remove-item')) {
            e.target.closest('.item-row').remove();
            updateRemoveButtons();
        }
    });

    function updateRemoveButtons() {
        const rows = document.querySelectorAll('.item-row');
        rows.forEach((row, index) => {
            const btn = row.querySelector('.remove-item');
            if (btn) btn.style.display = rows.length > 1 ? 'flex' : 'none';
        });
    }

    // Initial check
    updateRemoveButtons();
</script>
@endpush
@endsection
