@extends('admin.layouts.app')

@section('title', 'Settings')

@section('content')
<form method="POST" action="{{ route('admin.settings.update') }}" enctype="multipart/form-data">
    @csrf

    <div class="grid grid-2">
        <!-- Company Settings -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><i class="fas fa-building"></i> Company Information</h3>
            </div>

            <div class="form-group">
                <label class="form-label">Company Name</label>
                <input type="text" name="company_name" class="form-input" value="{{ $settings['company']['company_name'] ?? '' }}">
            </div>

            <div class="form-group">
                <label class="form-label">Email</label>
                <input type="email" name="company_email" class="form-input" value="{{ $settings['company']['company_email'] ?? '' }}">
            </div>

            <div class="form-group">
                <label class="form-label">Phone</label>
                <input type="text" name="company_phone" class="form-input" value="{{ $settings['company']['company_phone'] ?? '' }}">
            </div>

            <div class="form-group">
                <label class="form-label">Address</label>
                <textarea name="company_address" class="form-textarea" rows="2">{{ $settings['company']['company_address'] ?? '' }}</textarea>
            </div>

            <div class="form-group mb-0">
                <label class="form-label">Company Logo</label>
                @if(!empty($settings['company']['company_logo']))
                    <div class="mb-2">
                        <img src="{{ asset('storage/' . $settings['company']['company_logo']) }}" alt="Logo" style="max-height: 60px;">
                    </div>
                @endif
                <input type="file" name="company_logo" class="form-input" accept="image/*">
            </div>
        </div>

        <!-- Discount Settings -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><i class="fas fa-percent"></i> Installation Discount</h3>
            </div>

            <div class="alert" style="background: rgba(14, 165, 233, 0.1); border: 1px solid rgba(14, 165, 233, 0.3);">
                <i class="fas fa-info-circle text-primary"></i>
                <div>Customers who purchase equipment from your shop receive a discount on installation services.</div>
            </div>

            <div class="form-group">
                <label class="form-label">Discount Percentage (%)</label>
                <input type="number" name="installation_discount" class="form-input" 
                       value="{{ $settings['discount']['installation_discount'] ?? 10 }}" min="0" max="100" step="0.5">
                <small class="text-muted">Currently set at {{ $settings['discount']['installation_discount'] ?? 10 }}% off installation for shop customers</small>
            </div>

            <div class="form-group mb-0">
                <label class="flex items-center gap-2">
                    <input type="checkbox" name="enable_installation_discount" value="1" 
                           {{ ($settings['discount']['enable_installation_discount'] ?? true) ? 'checked' : '' }}>
                    <span>Enable automatic installation discount for shop customers</span>
                </label>
            </div>
        </div>
    </div>

    <!-- Payment Settings -->
    <div class="grid grid-2">
        <!-- M-Pesa Settings -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><i class="fas fa-mobile-alt"></i> M-Pesa Payment</h3>
            </div>

            <div class="form-group">
                <label class="flex items-center gap-2">
                    <input type="checkbox" name="mpesa_enabled" value="1" 
                           {{ ($settings['payment']['mpesa_enabled'] ?? true) ? 'checked' : '' }}>
                    <span>Enable M-Pesa Payments</span>
                </label>
            </div>

            <div class="form-group">
                <label class="form-label">Till Number (Buy Goods)</label>
                <input type="text" name="mpesa_till_number" class="form-input" 
                       value="{{ $settings['payment']['mpesa_till_number'] ?? '' }}" placeholder="e.g., 123456">
            </div>

            <div class="form-group">
                <label class="form-label">Consumer Key</label>
                <input type="text" name="mpesa_consumer_key" class="form-input" 
                       value="{{ $settings['payment']['mpesa_consumer_key'] ?? '' }}" placeholder="Daraja API Consumer Key">
            </div>

            <div class="form-group">
                <label class="form-label">Consumer Secret</label>
                <input type="password" name="mpesa_consumer_secret" class="form-input" 
                       value="{{ $settings['payment']['mpesa_consumer_secret'] ?? '' }}" placeholder="Daraja API Consumer Secret">
            </div>

            <div class="form-group">
                <label class="form-label">Passkey</label>
                <input type="password" name="mpesa_passkey" class="form-input" 
                       value="{{ $settings['payment']['mpesa_passkey'] ?? '' }}" placeholder="STK Push Passkey">
            </div>

            <div class="form-group mb-0">
                <label class="form-label">Environment</label>
                <select name="mpesa_environment" class="form-select">
                    <option value="sandbox" {{ ($settings['payment']['mpesa_environment'] ?? 'sandbox') == 'sandbox' ? 'selected' : '' }}>Sandbox (Testing)</option>
                    <option value="production" {{ ($settings['payment']['mpesa_environment'] ?? '') == 'production' ? 'selected' : '' }}>Production (Live)</option>
                </select>
            </div>
        </div>

        <!-- Bank Settings -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><i class="fas fa-university"></i> Bank Payment</h3>
            </div>

            <div class="form-group">
                <label class="flex items-center gap-2">
                    <input type="checkbox" name="bank_enabled" value="1" 
                           {{ ($settings['payment']['bank_enabled'] ?? true) ? 'checked' : '' }}>
                    <span>Enable Bank Payments</span>
                </label>
            </div>

            <div class="form-group">
                <label class="form-label">Bank Name</label>
                <input type="text" name="bank_name" class="form-input" 
                       value="{{ $settings['payment']['bank_name'] ?? '' }}" placeholder="e.g., Equity Bank">
            </div>

            <div class="form-group">
                <label class="form-label">Account Name</label>
                <input type="text" name="bank_account_name" class="form-input" 
                       value="{{ $settings['payment']['bank_account_name'] ?? '' }}">
            </div>

            <div class="form-group">
                <label class="form-label">Account Number</label>
                <input type="text" name="bank_account_number" class="form-input" 
                       value="{{ $settings['payment']['bank_account_number'] ?? '' }}">
            </div>

            <div class="form-group mb-0">
                <label class="form-label">Branch</label>
                <input type="text" name="bank_branch" class="form-input" 
                       value="{{ $settings['payment']['bank_branch'] ?? '' }}">
            </div>
        </div>
    </div>

    <!-- General Settings -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title"><i class="fas fa-cog"></i> General Settings</h3>
        </div>

        <div class="grid grid-3">
            <div class="form-group">
                <label class="form-label">Currency Code</label>
                <input type="text" name="currency" class="form-input" 
                       value="{{ $settings['general']['currency'] ?? 'KES' }}">
            </div>

            <div class="form-group">
                <label class="form-label">Currency Symbol</label>
                <input type="text" name="currency_symbol" class="form-input" 
                       value="{{ $settings['general']['currency_symbol'] ?? 'KSh' }}">
            </div>

            <div class="form-group">
                <label class="form-label">Quotation Validity (Days)</label>
                <input type="number" name="quotation_validity_days" class="form-input" 
                       value="{{ $settings['general']['quotation_validity_days'] ?? 30 }}" min="1">
            </div>
        </div>

        <div class="form-group mb-0">
            <label class="form-label">Default Terms & Conditions</label>
            <textarea name="default_terms" class="form-textarea" rows="4">{{ $settings['general']['default_terms'] ?? '' }}</textarea>
        </div>
    </div>

    <button type="submit" class="btn btn-primary">
        <i class="fas fa-save"></i> Save Settings
    </button>
</form>
@endsection
