@extends('admin.layouts.app')

@section('title', 'Users')

@section('content')
<div class="flex justify-between items-center mb-3">
    <h2 style="font-size: 1.5rem; font-weight: 600;">User Management</h2>
</div>

<!-- Filters -->
<div class="card mb-3">
    <form method="GET" action="{{ route('admin.users.index') }}" class="flex gap-3 items-center" style="flex-wrap: wrap;">
        <div class="form-group mb-0" style="flex: 1; min-width: 200px;">
            <input type="text" name="search" class="form-input" placeholder="Search by name or email..." value="{{ request('search') }}">
        </div>
        <div class="form-group mb-0">
            <select name="role" class="form-select" style="min-width: 150px;">
                <option value="">All Roles</option>
                <option value="admin" {{ request('role') == 'admin' ? 'selected' : '' }}>Admins</option>
                <option value="customer" {{ request('role') == 'customer' ? 'selected' : '' }}>Customers</option>
            </select>
        </div>
        <button type="submit" class="btn btn-primary">
            <i class="fas fa-search"></i> Search
        </button>
        @if(request()->hasAny(['search', 'role']))
            <a href="{{ route('admin.users.index') }}" class="btn btn-secondary">Clear</a>
        @endif
    </form>
</div>

<!-- Users Table -->
<div class="card">
    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th>User</th>
                    <th>Email</th>
                    <th>Role</th>
                    <th>Orders</th>
                    <th>Total Spent</th>
                    <th>Status</th>
                    <th>Joined</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($users as $user)
                    <tr>
                        <td>
                            <div style="display: flex; align-items: center; gap: 0.75rem;">
                                <div style="width: 40px; height: 40px; border-radius: 50%; background: var(--primary); display: flex; align-items: center; justify-content: center; font-weight: 600;">
                                    {{ strtoupper(substr($user->name, 0, 1)) }}
                                </div>
                                <div>
                                    <div style="font-weight: 500;">{{ $user->name }}</div>
                                    @if($user->phone)
                                        <div style="font-size: 0.8rem; color: #64748b;">{{ $user->phone }}</div>
                                    @endif
                                </div>
                            </div>
                        </td>
                        <td>{{ $user->email }}</td>
                        <td>
                            <span class="badge badge-{{ $user->role === 'admin' ? 'primary' : 'secondary' }}">
                                {{ ucfirst($user->role) }}
                            </span>
                        </td>
                        <td>{{ $user->orders_count ?? $user->orders()->count() }}</td>
                        <td>KSh {{ number_format($user->total_spent, 2) }}</td>
                        <td>
                            <span class="badge badge-{{ $user->is_active ? 'success' : 'danger' }}">
                                {{ $user->is_active ? 'Active' : 'Inactive' }}
                            </span>
                        </td>
                        <td>{{ $user->created_at->format('M d, Y') }}</td>
                        <td>
                            <div style="display: flex; gap: 0.5rem;">
                                <a href="{{ route('admin.users.show', $user) }}" class="btn btn-secondary btn-sm" title="View Details">
                                    <i class="fas fa-eye"></i>
                                </a>
                                @if($user->id !== auth()->id())
                                    <form action="{{ route('admin.users.toggle-status', $user) }}" method="POST" style="display: inline;">
                                        @csrf
                                        @method('PATCH')
                                        <button type="submit" class="btn btn-{{ $user->is_active ? 'warning' : 'success' }} btn-sm" 
                                                title="{{ $user->is_active ? 'Deactivate' : 'Activate' }}"
                                                onclick="return confirm('{{ $user->is_active ? 'Deactivate' : 'Activate' }} this user?')">
                                            <i class="fas fa-{{ $user->is_active ? 'ban' : 'check' }}"></i>
                                        </button>
                                    </form>
                                @endif
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="8" class="text-muted text-center" style="padding: 2rem;">
                            <i class="fas fa-users" style="font-size: 2rem; margin-bottom: 0.5rem; display: block;"></i>
                            No users found
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    @if($users->hasPages())
        <div class="pagination" style="margin-top: 1rem;">
            {{ $users->links() }}
        </div>
    @endif
</div>

<style>
    .btn-warning {
        background: rgba(245, 158, 11, 0.2);
        color: var(--warning);
        border: 1px solid rgba(245, 158, 11, 0.3);
    }
    .btn-warning:hover {
        background: var(--warning);
        color: white;
    }
</style>
@endsection
