@extends('layouts.app')

@section('title', 'Order Confirmation')

@section('content')
<div class="confirmation-container">
    <div class="confirmation-card">
        <div class="success-icon">
            <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <circle cx="12" cy="12" r="10"/>
                <path d="M9 12l2 2 4-4"/>
            </svg>
        </div>
        
        <h1>Order Placed Successfully!</h1>
        <p class="order-number">Order #{{ $order->order_number }}</p>
        
        <div class="order-summary">
            <h3>Order Summary</h3>
            <table>
                <thead>
                    <tr>
                        <th>Item</th>
                        <th>Qty</th>
                        <th>Price</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($order->items as $item)
                    <tr>
                        <td>{{ $item->product_name }}</td>
                        <td>{{ $item->quantity }}</td>
                        <td>KSh {{ number_format($item->subtotal, 2) }}</td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    @if($order->installation_cost > 0)
                    <tr>
                        <td colspan="2">Installation</td>
                        <td>KSh {{ number_format($order->installation_cost, 2) }}</td>
                    </tr>
                    @endif
                    <tr class="total-row">
                        <td colspan="2"><strong>Total</strong></td>
                        <td><strong>KSh {{ number_format($order->total, 2) }}</strong></td>
                    </tr>
                </tfoot>
            </table>
        </div>

        <div class="whatsapp-section">
            <p>Click below to send your order to our WhatsApp for faster processing:</p>
            <a href="{{ $whatsappLink }}" target="_blank" class="whatsapp-btn">
                <svg viewBox="0 0 24 24" fill="currentColor" width="24" height="24">
                    <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413z"/>
                </svg>
                Send Order via WhatsApp
            </a>
        </div>

        <div class="next-steps">
            <h3>What's Next?</h3>
            <ul>
                <li>Click the WhatsApp button above to confirm your order with us</li>
                <li>Our team will contact you to confirm delivery details</li>
                <li>Track your order status in your dashboard</li>
            </ul>
        </div>

        <div class="action-buttons">
            <a href="{{ route('dashboard') }}" class="btn btn-secondary">View My Orders</a>
            <a href="{{ route('shop.home') }}" class="btn btn-primary">Continue Shopping</a>
        </div>
    </div>
</div>

<style>
.confirmation-container {
    min-height: 80vh;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 2rem;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.confirmation-card {
    background: white;
    border-radius: 20px;
    padding: 3rem;
    max-width: 600px;
    width: 100%;
    text-align: center;
    box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
}

.success-icon {
    width: 80px;
    height: 80px;
    margin: 0 auto 1.5rem;
    color: #10b981;
}

.success-icon svg {
    width: 100%;
    height: 100%;
}

.confirmation-card h1 {
    font-size: 1.75rem;
    color: #1f2937;
    margin-bottom: 0.5rem;
}

.order-number {
    font-size: 1.1rem;
    color: #6b7280;
    font-weight: 600;
    margin-bottom: 2rem;
}

.order-summary {
    background: #f9fafb;
    border-radius: 12px;
    padding: 1.5rem;
    margin-bottom: 2rem;
    text-align: left;
}

.order-summary h3 {
    font-size: 1rem;
    color: #374151;
    margin-bottom: 1rem;
    text-align: center;
}

.order-summary table {
    width: 100%;
    border-collapse: collapse;
}

.order-summary th,
.order-summary td {
    padding: 0.75rem 0.5rem;
    border-bottom: 1px solid #e5e7eb;
}

.order-summary th {
    font-size: 0.75rem;
    text-transform: uppercase;
    color: #6b7280;
    font-weight: 600;
}

.order-summary td {
    font-size: 0.9rem;
    color: #374151;
}

.order-summary tfoot td {
    border-bottom: none;
}

.order-summary .total-row td {
    padding-top: 1rem;
    font-size: 1rem;
    color: #1f2937;
}

.whatsapp-section {
    margin-bottom: 2rem;
}

.whatsapp-section p {
    color: #6b7280;
    margin-bottom: 1rem;
}

.whatsapp-btn {
    display: inline-flex;
    align-items: center;
    gap: 0.75rem;
    background: #25d366;
    color: white;
    padding: 1rem 2rem;
    border-radius: 50px;
    font-size: 1.1rem;
    font-weight: 600;
    text-decoration: none;
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px rgba(37, 211, 102, 0.4);
}

.whatsapp-btn:hover {
    background: #128c7e;
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(37, 211, 102, 0.5);
}

.next-steps {
    background: #fef3c7;
    border-radius: 12px;
    padding: 1.5rem;
    margin-bottom: 2rem;
    text-align: left;
}

.next-steps h3 {
    font-size: 1rem;
    color: #92400e;
    margin-bottom: 0.75rem;
}

.next-steps ul {
    list-style: none;
    padding: 0;
    margin: 0;
}

.next-steps li {
    position: relative;
    padding-left: 1.5rem;
    margin-bottom: 0.5rem;
    color: #b45309;
    font-size: 0.9rem;
}

.next-steps li::before {
    content: '';
    position: absolute;
    left: 0;
    top: 0.5rem;
    width: 8px;
    height: 8px;
    background: #f59e0b;
    border-radius: 50%;
}

.action-buttons {
    display: flex;
    gap: 1rem;
    justify-content: center;
    flex-wrap: wrap;
}

.action-buttons .btn {
    padding: 0.75rem 1.5rem;
    border-radius: 8px;
    font-weight: 600;
    text-decoration: none;
    transition: all 0.3s ease;
}

.btn-secondary {
    background: #f3f4f6;
    color: #374151;
}

.btn-secondary:hover {
    background: #e5e7eb;
}

.btn-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
}

@media (max-width: 640px) {
    .confirmation-card {
        padding: 2rem 1.5rem;
    }
    
    .action-buttons {
        flex-direction: column;
    }
    
    .action-buttons .btn {
        width: 100%;
        text-align: center;
    }
}
</style>
@endsection
