<?php

use App\Http\Controllers\Api\OrderProcessingController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group.
|
*/

// Order Processing Webhooks
Route::prefix('orders/webhook')->group(function () {
    // Email webhook endpoint
    Route::post('/email', [OrderProcessingController::class, 'processEmailWebhook'])
        ->name('api.orders.webhook.email');
    
    // WhatsApp webhook endpoints
    Route::post('/whatsapp', [OrderProcessingController::class, 'processWhatsAppWebhook'])
        ->name('api.orders.webhook.whatsapp');
    
    // WhatsApp verification endpoint (GET request for provider setup)
    Route::get('/whatsapp', [OrderProcessingController::class, 'verifyWhatsAppWebhook'])
        ->name('api.orders.webhook.whatsapp.verify');
});
