

<?php $__env->startSection('title', 'Products - Onespot Solutions Shop'); ?>
<?php $__env->startSection('description', 'Browse our wide range of security equipment - CCTV cameras, access controls, smart locks, and more.'); ?>

<?php $__env->startSection('content'); ?>
<style>
    /* Products Page Styles */
    .filters-bar {
        background: rgba(30, 41, 59, 0.6);
        border: 1px solid rgba(255, 255, 255, 0.1);
        border-radius: 12px;
        padding: 1rem 1.5rem;
        margin-bottom: 2rem;
        display: flex;
        align-items: center;
        justify-content: space-between;
        flex-wrap: wrap;
        gap: 1rem;
    }

    .filters-left {
        display: flex;
        align-items: center;
        gap: 1rem;
    }

    .filter-select {
        background: rgba(15, 23, 42, 0.8);
        border: 1px solid rgba(255, 255, 255, 0.1);
        border-radius: 8px;
        padding: 0.5rem 1rem;
        color: #e2e8f0;
        font-size: 0.9rem;
        cursor: pointer;
    }

    .filter-select:focus {
        outline: none;
        border-color: var(--primary);
    }

    .results-count {
        color: #64748b;
        font-size: 0.9rem;
    }

    .products-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
        gap: 1.5rem;
    }

    .product-card {
        background: rgba(30, 41, 59, 0.6);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.1);
        border-radius: 16px;
        overflow: hidden;
        transition: all 0.3s;
    }

    .product-card:hover {
        transform: translateY(-5px);
        border-color: rgba(14, 165, 233, 0.3);
        box-shadow: 0 20px 40px -15px rgba(0, 0, 0, 0.5);
    }

    .product-image {
        aspect-ratio: 4/3;
        background: rgba(15, 23, 42, 0.8);
        display: flex;
        align-items: center;
        justify-content: center;
        position: relative;
    }

    .product-image img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .product-image i {
        font-size: 3rem;
        color: #475569;
    }

    .product-badge {
        position: absolute;
        top: 1rem;
        left: 1rem;
        background: var(--danger);
        color: white;
        padding: 0.25rem 0.75rem;
        border-radius: 999px;
        font-size: 0.75rem;
        font-weight: 600;
    }

    .product-content {
        padding: 1.25rem;
    }

    .product-category {
        color: var(--primary);
        font-size: 0.8rem;
        font-weight: 500;
        margin-bottom: 0.5rem;
    }

    .product-title {
        font-size: 1rem;
        font-weight: 600;
        margin-bottom: 0.5rem;
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }

    .product-price {
        display: flex;
        align-items: center;
        gap: 0.5rem;
        margin-bottom: 1rem;
    }

    .product-price .current {
        font-size: 1.25rem;
        font-weight: 700;
        color: var(--success);
    }

    .product-price .original {
        color: #64748b;
        text-decoration: line-through;
        font-size: 0.9rem;
    }

    .product-actions {
        display: flex;
        gap: 0.5rem;
    }

    .product-actions .btn {
        flex: 1;
        justify-content: center;
    }

    .pagination-wrapper {
        display: flex;
        justify-content: center;
        margin-top: 3rem;
    }

    .pagination {
        display: flex;
        gap: 0.5rem;
    }

    .pagination a, .pagination span {
        padding: 0.5rem 1rem;
        background: rgba(30, 41, 59, 0.6);
        border: 1px solid rgba(255, 255, 255, 0.1);
        border-radius: 8px;
        color: #94a3b8;
        transition: all 0.2s;
    }

    .pagination a:hover {
        border-color: var(--primary);
        color: var(--primary);
    }

    .pagination .active span {
        background: var(--primary);
        border-color: var(--primary);
        color: white;
    }

    .empty-state {
        text-align: center;
        padding: 4rem 2rem;
    }

    .empty-state i {
        font-size: 4rem;
        color: #475569;
        margin-bottom: 1rem;
    }

    .empty-state h3 {
        margin-bottom: 0.5rem;
    }

    .empty-state p {
        color: #64748b;
    }
</style>

<!-- Page Header -->
<div class="page-header">
    <div class="page-header-content">
        <div class="breadcrumb">
            <a href="<?php echo e(route('shop.home')); ?>">Home</a>
            <span>/</span>
            <span>Products</span>
        </div>
        <h1>All Products</h1>
        <p>Browse our complete catalog of security equipment</p>
    </div>
</div>

<!-- Main Content -->
<div class="main-content">
    <!-- Filters Bar -->
    <div class="filters-bar">
        <div class="filters-left">
            <form action="<?php echo e(route('shop.products')); ?>" method="GET" id="filterForm">
                <select name="category" class="filter-select" onchange="document.getElementById('filterForm').submit()">
                    <option value="">All Categories</option>
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($category->id); ?>" <?php echo e(request('category') == $category->id ? 'selected' : ''); ?>>
                            <?php echo e($category->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <select name="sort" class="filter-select" onchange="document.getElementById('filterForm').submit()">
                    <option value="newest" <?php echo e(request('sort') == 'newest' ? 'selected' : ''); ?>>Newest First</option>
                    <option value="price_low" <?php echo e(request('sort') == 'price_low' ? 'selected' : ''); ?>>Price: Low to High</option>
                    <option value="price_high" <?php echo e(request('sort') == 'price_high' ? 'selected' : ''); ?>>Price: High to Low</option>
                    <option value="name" <?php echo e(request('sort') == 'name' ? 'selected' : ''); ?>>Name: A-Z</option>
                </select>
            </form>
        </div>
        <div class="results-count">
            Showing <?php echo e($products->count()); ?> of <?php echo e($products->total()); ?> products
        </div>
    </div>

    <?php if($products->count() > 0): ?>
        <!-- Products Grid -->
        <div class="products-grid">
            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="product-card">
                    <div class="product-image">
                        <?php if($product->images->count() > 0): ?>
                            <img src="<?php echo e(Storage::url($product->images->first()->path)); ?>" alt="<?php echo e($product->name); ?>">
                        <?php else: ?>
                            <i class="fas fa-box"></i>
                        <?php endif; ?>
                        <?php if($product->sale_price && $product->sale_price < $product->price): ?>
                            <?php
                                $discount = round((($product->price - $product->sale_price) / $product->price) * 100);
                            ?>
                            <span class="product-badge">-<?php echo e($discount); ?>%</span>
                        <?php endif; ?>
                    </div>
                    <div class="product-content">
                        <div class="product-category"><?php echo e($product->category->name ?? 'Uncategorized'); ?></div>
                        <h3 class="product-title"><?php echo e($product->name); ?></h3>
                        <div class="product-price">
                            <?php if($product->sale_price && $product->sale_price < $product->price): ?>
                                <span class="current">KSh <?php echo e(number_format($product->sale_price)); ?></span>
                                <span class="original">KSh <?php echo e(number_format($product->price)); ?></span>
                            <?php else: ?>
                                <span class="current">KSh <?php echo e(number_format($product->price)); ?></span>
                            <?php endif; ?>
                        </div>
                        <div class="product-actions">
                            <?php if(auth()->guard()->check()): ?>
                                <form action="<?php echo e(route('cart.add')); ?>" method="POST" style="flex: 1;">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                                    <input type="hidden" name="quantity" value="1">
                                    <button type="submit" class="btn btn-primary" style="width: 100%;" <?php echo e(!$product->in_stock ? 'disabled' : ''); ?>>
                                        <?php echo e($product->in_stock ? 'Add to Cart' : 'Out of Stock'); ?>

                                    </button>
                                </form>
                            <?php else: ?>
                                <a href="<?php echo e(route('login')); ?>" class="btn btn-primary" style="flex: 1; justify-content: center;">Add to Cart</a>
                            <?php endif; ?>
                            <a href="<?php echo e(route('shop.product', $product)); ?>" class="btn btn-secondary"><i class="fas fa-eye"></i></a>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <!-- Pagination -->
        <?php if($products->hasPages()): ?>
            <div class="pagination-wrapper">
                <?php echo e($products->withQueryString()->links()); ?>

            </div>
        <?php endif; ?>
    <?php else: ?>
        <div class="empty-state">
            <i class="fas fa-box-open"></i>
            <h3>No Products Found</h3>
            <p>We couldn't find any products matching your criteria.</p>
            <a href="<?php echo e(route('shop.products')); ?>" class="btn btn-primary" style="margin-top: 1rem;">View All Products</a>
        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('shop.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\shop\resources\views/shop/products.blade.php ENDPATH**/ ?>