

<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<!-- Quick Actions -->
<div class="quick-actions-card">
    <div class="quick-actions-header">
        <h3><i class="fas fa-bolt"></i> Quick Actions</h3>
    </div>
    <div class="quick-actions-body">
        <button type="button" class="btn btn-primary" onclick="openInvoiceModal()">
            <i class="fas fa-file-invoice"></i> Generate Invoice
        </button>
        <a href="<?php echo e(route('admin.quotations.create')); ?>" class="btn btn-secondary">
            <i class="fas fa-plus"></i> New Quotation
        </a>
        <a href="<?php echo e(route('admin.products.create')); ?>" class="btn btn-secondary">
            <i class="fas fa-box"></i> Add Product
        </a>
        <a href="<?php echo e(route('admin.orders.index')); ?>" class="btn btn-secondary">
            <i class="fas fa-shopping-cart"></i> View Orders
        </a>
    </div>
</div>

<!-- Invoice Type Selection Modal -->
<div id="invoiceTypeModal" class="modal-overlay" style="display: none;">
    <div class="modal-container">
        <div class="modal-header">
            <h3><i class="fas fa-file-invoice"></i> Generate Invoice</h3>
            <button type="button" class="modal-close" onclick="closeInvoiceModal()">&times;</button>
        </div>
        <div class="modal-body">
            <p class="modal-description">Select the type of invoice you want to create:</p>
            
            <div class="invoice-type-options">
                <a href="<?php echo e(route('admin.quotations.create', ['type' => 'services'])); ?>" class="invoice-type-card">
                    <div class="invoice-type-icon services">
                        <i class="fas fa-tools"></i>
                    </div>
                    <h4>Services Invoice</h4>
                    <p>For installation, maintenance, repairs, and other services offered to clients</p>
                </a>
                
                <a href="<?php echo e(route('admin.quotations.create', ['type' => 'products'])); ?>" class="invoice-type-card">
                    <div class="invoice-type-icon products">
                        <i class="fas fa-box"></i>
                    </div>
                    <h4>Products Quotation</h4>
                    <p>For product sales, equipment billing, and product-based quotations</p>
                </a>
            </div>
        </div>
    </div>
</div>

<style>
.quick-actions-card {
    background: rgba(30, 41, 59, 0.8);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 12px;
    margin-bottom: 1.5rem;
}

.quick-actions-header {
    padding: 1rem 1.5rem;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.quick-actions-header h3 {
    font-size: 1rem;
    font-weight: 600;
    color: #e2e8f0;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.quick-actions-header i {
    color: var(--warning);
}

.quick-actions-body {
    padding: 1.5rem;
    display: flex;
    flex-wrap: wrap;
    gap: 1rem;
}

/* Modal Styles */
.modal-overlay {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0, 0, 0, 0.7);
    backdrop-filter: blur(4px);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 9999;
}

.modal-container {
    background: #1e293b;
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 16px;
    max-width: 600px;
    width: 95%;
    max-height: 90vh;
    overflow-y: auto;
    box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.5);
}

.modal-header {
    padding: 1.5rem;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.modal-header h3 {
    font-size: 1.25rem;
    font-weight: 600;
    color: #e2e8f0;
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.modal-header h3 i {
    color: var(--primary);
}

.modal-close {
    background: none;
    border: none;
    color: #94a3b8;
    font-size: 1.5rem;
    cursor: pointer;
    padding: 0;
    line-height: 1;
}

.modal-close:hover {
    color: #e2e8f0;
}

.modal-body {
    padding: 1.5rem;
}

.modal-description {
    color: #94a3b8;
    margin-bottom: 1.5rem;
    text-align: center;
}

.invoice-type-options {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 1rem;
}

.invoice-type-card {
    background: rgba(15, 23, 42, 0.8);
    border: 2px solid rgba(255, 255, 255, 0.1);
    border-radius: 12px;
    padding: 1.5rem;
    text-align: center;
    cursor: pointer;
    transition: all 0.3s;
    text-decoration: none;
    color: inherit;
}

.invoice-type-card:hover {
    border-color: var(--primary);
    background: rgba(14, 165, 233, 0.1);
    transform: translateY(-3px);
}

.invoice-type-icon {
    width: 70px;
    height: 70px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1rem;
}

.invoice-type-icon.services {
    background: linear-gradient(135deg, rgba(34, 197, 94, 0.2), rgba(34, 197, 94, 0.1));
}

.invoice-type-icon.services i {
    font-size: 1.75rem;
    color: var(--success);
}

.invoice-type-icon.products {
    background: linear-gradient(135deg, rgba(14, 165, 233, 0.2), rgba(14, 165, 233, 0.1));
}

.invoice-type-icon.products i {
    font-size: 1.75rem;
    color: var(--primary);
}

.invoice-type-card h4 {
    font-size: 1rem;
    font-weight: 600;
    color: #e2e8f0;
    margin-bottom: 0.5rem;
}

.invoice-type-card p {
    font-size: 0.85rem;
    color: #64748b;
    line-height: 1.4;
}

@media (max-width: 576px) {
    .invoice-type-options {
        grid-template-columns: 1fr;
    }
}
</style>

<script>
function openInvoiceModal() {
    document.getElementById('invoiceTypeModal').style.display = 'flex';
}

function closeInvoiceModal() {
    document.getElementById('invoiceTypeModal').style.display = 'none';
}

// Close modal when clicking outside
document.getElementById('invoiceTypeModal')?.addEventListener('click', function(e) {
    if (e.target === this) {
        closeInvoiceModal();
    }
});

// Close modal on Escape key
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        closeInvoiceModal();
    }
});
</script>

<!-- Stats Grid -->
<div class="stats-grid">
    <div class="stat-card primary">
        <div class="stat-icon">
            <i class="fas fa-box"></i>
        </div>
        <div class="stat-value"><?php echo e(number_format($stats['total_products'])); ?></div>
        <div class="stat-label">Total Products</div>
    </div>

    <div class="stat-card success">
        <div class="stat-icon">
            <i class="fas fa-shopping-cart"></i>
        </div>
        <div class="stat-value"><?php echo e(number_format($stats['total_orders'])); ?></div>
        <div class="stat-label">Total Orders</div>
    </div>

    <div class="stat-card primary">
        <div class="stat-icon">
            <i class="fas fa-users"></i>
        </div>
        <div class="stat-value"><?php echo e(number_format($stats['total_customers'])); ?></div>
        <div class="stat-label">Customers</div>
    </div>

    <div class="stat-card success">
        <div class="stat-icon">
            <i class="fas fa-coins"></i>
        </div>
        <div class="stat-value">KSh <?php echo e(number_format($stats['total_revenue'], 2)); ?></div>
        <div class="stat-label">Total Revenue</div>
    </div>
</div>

<!-- Secondary Stats -->
<div class="stats-grid">
    <div class="stat-card warning">
        <div class="stat-icon">
            <i class="fas fa-clock"></i>
        </div>
        <div class="stat-value"><?php echo e(number_format($stats['pending_orders'])); ?></div>
        <div class="stat-label">Pending Orders</div>
    </div>

    <div class="stat-card warning">
        <div class="stat-icon">
            <i class="fas fa-exclamation-triangle"></i>
        </div>
        <div class="stat-value"><?php echo e(number_format($stats['low_stock_products'])); ?></div>
        <div class="stat-label">Low Stock Products</div>
    </div>

    <div class="stat-card danger">
        <div class="stat-icon">
            <i class="fas fa-times-circle"></i>
        </div>
        <div class="stat-value"><?php echo e(number_format($stats['out_of_stock'])); ?></div>
        <div class="stat-label">Out of Stock</div>
    </div>

    <div class="stat-card primary">
        <div class="stat-icon">
            <i class="fas fa-file-invoice"></i>
        </div>
        <div class="stat-value"><?php echo e(number_format($stats['active_quotations'])); ?></div>
        <div class="stat-label">Active Quotations</div>
    </div>
</div>

<!-- Recent Orders & Top Products -->
<div class="grid grid-2">
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Recent Orders</h3>
            <a href="<?php echo e(route('admin.orders.index')); ?>" class="btn btn-secondary btn-sm">View All</a>
        </div>
        <div class="table-container">
            <table>
                <thead>
                    <tr>
                        <th>Order #</th>
                        <th>Customer</th>
                        <th>Total</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $recentOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <a href="<?php echo e(route('admin.orders.show', $order)); ?>" class="text-primary">
                                <?php echo e($order->order_number); ?>

                            </a>
                        </td>
                        <td><?php echo e($order->customer_name); ?></td>
                        <td>KSh <?php echo e(number_format($order->total, 2)); ?></td>
                        <td>
                            <span class="badge badge-<?php echo e($order->status_badge['color']); ?>">
                                <?php echo e($order->status_badge['label']); ?>

                            </span>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="4" class="text-muted text-center">No orders yet</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Top Products</h3>
            <a href="<?php echo e(route('admin.products.index')); ?>" class="btn btn-secondary btn-sm">View All</a>
        </div>
        <div class="table-container">
            <table>
                <thead>
                    <tr>
                        <th>Product</th>
                        <th>Price</th>
                        <th>Orders</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $topProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <a href="<?php echo e(route('admin.products.edit', $product)); ?>" class="text-primary">
                                <?php echo e(Str::limit($product->name, 30)); ?>

                            </a>
                        </td>
                        <td>KSh <?php echo e(number_format($product->price, 2)); ?></td>
                        <td><?php echo e($product->order_items_count); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="3" class="text-muted text-center">No products yet</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Recent Quotations -->
<div class="card">
    <div class="card-header">
        <h3 class="card-title">Recent Quotations</h3>
        <a href="<?php echo e(route('admin.quotations.index')); ?>" class="btn btn-secondary btn-sm">View All</a>
    </div>
    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th>Quotation #</th>
                    <th>Customer</th>
                    <th>Total</th>
                    <th>Status</th>
                    <th>Valid Until</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $recentQuotations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $quotation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td>
                        <a href="<?php echo e(route('admin.quotations.show', $quotation)); ?>" class="text-primary">
                            <?php echo e($quotation->quotation_number); ?>

                        </a>
                    </td>
                    <td><?php echo e($quotation->customer_name); ?></td>
                    <td>KSh <?php echo e(number_format($quotation->total, 2)); ?></td>
                    <td>
                        <span class="badge badge-<?php echo e($quotation->status_badge['color']); ?>">
                            <?php echo e($quotation->status_badge['label']); ?>

                        </span>
                    </td>
                    <td><?php echo e($quotation->valid_until?->format('M d, Y') ?? '-'); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="5" class="text-muted text-center">No quotations yet</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\shop\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>