<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <style>
        :root {
            --primary: #0ea5e9;
            --primary-dark: #0284c7;
            --secondary: #64748b;
            --success: #22c55e;
            --danger: #ef4444;
            --warning: #f59e0b;
            --dark: #0f172a;
            --darker: #020617;
        }

        .dashboard-container {
            min-height: calc(100vh - 64px);
            background: linear-gradient(135deg, var(--darker) 0%, var(--dark) 50%, #0c1929 100%);
            color: #e2e8f0;
        }

        .dashboard-content {
            max-width: 1400px;
            margin: 0 auto;
            padding: 2rem;
        }

        /* Welcome Banner */
        .welcome-banner {
            background: linear-gradient(135deg, rgba(14, 165, 233, 0.15) 0%, rgba(34, 197, 94, 0.1) 100%);
            border: 1px solid rgba(14, 165, 233, 0.2);
            border-radius: 20px;
            padding: 2rem;
            margin-bottom: 2rem;
            position: relative;
            overflow: hidden;
        }

        .welcome-banner::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -20%;
            width: 400px;
            height: 400px;
            background: radial-gradient(circle, rgba(14, 165, 233, 0.2) 0%, transparent 70%);
            animation: pulse 4s ease-in-out infinite;
        }

        @keyframes pulse {
            0%, 100% { transform: scale(1); opacity: 0.5; }
            50% { transform: scale(1.1); opacity: 0.8; }
        }

        .welcome-banner h1 {
            font-size: 1.75rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
            position: relative;
        }

        .welcome-banner h1 span {
            background: linear-gradient(90deg, #0ea5e9, #22c55e);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .welcome-banner p {
            color: #94a3b8;
            position: relative;
        }

        .welcome-banner .btn-shop {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.75rem 1.5rem;
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            color: white;
            font-weight: 600;
            border-radius: 12px;
            text-decoration: none;
            margin-top: 1rem;
            transition: all 0.3s;
            position: relative;
        }

        .welcome-banner .btn-shop:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 30px -10px rgba(14, 165, 233, 0.5);
        }

        /* Stats Grid */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 1.5rem;
            margin-bottom: 2rem;
        }

        @media (max-width: 1024px) {
            .stats-grid { grid-template-columns: repeat(2, 1fr); }
        }

        @media (max-width: 640px) {
            .stats-grid { grid-template-columns: 1fr; }
        }

        .stat-card {
            background: rgba(30, 41, 59, 0.6);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 16px;
            padding: 1.5rem;
            transition: all 0.3s;
        }

        .stat-card:hover {
            transform: translateY(-5px);
            border-color: rgba(14, 165, 233, 0.3);
            box-shadow: 0 20px 40px -15px rgba(0, 0, 0, 0.5);
        }

        .stat-card .icon {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.25rem;
            margin-bottom: 1rem;
        }

        .stat-card .icon.blue { background: rgba(14, 165, 233, 0.2); color: var(--primary); }
        .stat-card .icon.yellow { background: rgba(245, 158, 11, 0.2); color: var(--warning); }
        .stat-card .icon.green { background: rgba(34, 197, 94, 0.2); color: var(--success); }
        .stat-card .icon.purple { background: rgba(168, 85, 247, 0.2); color: #a855f7; }

        .stat-card .label {
            color: #64748b;
            font-size: 0.875rem;
            margin-bottom: 0.25rem;
        }

        .stat-card .value {
            font-size: 1.75rem;
            font-weight: 700;
            color: #f1f5f9;
        }

        /* Main Content Grid */
        .main-grid {
            display: grid;
            grid-template-columns: 2fr 1fr;
            gap: 1.5rem;
        }

        @media (max-width: 1024px) {
            .main-grid { grid-template-columns: 1fr; }
        }

        .glass-card {
            background: rgba(30, 41, 59, 0.6);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 16px;
            overflow: hidden;
        }

        .card-header {
            padding: 1.25rem 1.5rem;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .card-header h3 {
            font-size: 1.125rem;
            font-weight: 600;
            color: #f1f5f9;
        }

        .card-header a {
            color: var(--primary);
            font-size: 0.875rem;
            text-decoration: none;
            font-weight: 500;
            transition: color 0.2s;
        }

        .card-header a:hover {
            color: #38bdf8;
        }

        .card-body {
            padding: 1.5rem;
        }

        /* Orders List */
        .order-item {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 1rem;
            background: rgba(15, 23, 42, 0.5);
            border-radius: 12px;
            margin-bottom: 0.75rem;
            transition: all 0.2s;
        }

        .order-item:last-child {
            margin-bottom: 0;
        }

        .order-item:hover {
            background: rgba(14, 165, 233, 0.1);
            border-color: rgba(14, 165, 233, 0.2);
        }

        .order-icon {
            width: 45px;
            height: 45px;
            background: rgba(14, 165, 233, 0.15);
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--primary);
            margin-right: 1rem;
        }

        .order-info h4 {
            font-weight: 600;
            color: #f1f5f9;
            margin-bottom: 0.25rem;
        }

        .order-info span {
            color: #64748b;
            font-size: 0.875rem;
        }

        .order-status {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .status-badge {
            padding: 0.375rem 0.75rem;
            border-radius: 999px;
            font-size: 0.75rem;
            font-weight: 600;
        }

        .status-pending { background: rgba(245, 158, 11, 0.2); color: var(--warning); }
        .status-processing { background: rgba(14, 165, 233, 0.2); color: var(--primary); }
        .status-confirmed { background: rgba(99, 102, 241, 0.2); color: #818cf8; }
        .status-shipped { background: rgba(168, 85, 247, 0.2); color: #a855f7; }
        .status-delivered { background: rgba(34, 197, 94, 0.2); color: var(--success); }
        .status-cancelled { background: rgba(239, 68, 68, 0.2); color: var(--danger); }

        .order-price {
            font-weight: 600;
            color: #f1f5f9;
        }

        .empty-state {
            text-align: center;
            padding: 3rem 1rem;
        }

        .empty-state .icon {
            width: 70px;
            height: 70px;
            background: rgba(71, 85, 105, 0.3);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1rem;
            color: #64748b;
            font-size: 1.75rem;
        }

        .empty-state p {
            color: #64748b;
            margin-bottom: 1rem;
        }

        .btn-primary {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.75rem 1.5rem;
            background: var(--primary);
            color: white;
            font-weight: 600;
            border-radius: 10px;
            text-decoration: none;
            transition: all 0.3s;
        }

        .btn-primary:hover {
            background: var(--primary-dark);
            transform: translateY(-2px);
        }

        /* Cart Sidebar */
        .cart-badge {
            background: var(--primary);
            color: white;
            width: 24px;
            height: 24px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 0.75rem;
            font-weight: 600;
        }

        .cart-item {
            display: flex;
            align-items: center;
            gap: 1rem;
            margin-bottom: 1rem;
        }

        .cart-item:last-child {
            margin-bottom: 0;
        }

        .cart-item-image {
            width: 60px;
            height: 60px;
            background: rgba(15, 23, 42, 0.8);
            border-radius: 10px;
            overflow: hidden;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }

        .cart-item-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .cart-item-image i {
            color: #475569;
            font-size: 1.25rem;
        }

        .cart-item-info {
            flex: 1;
            min-width: 0;
        }

        .cart-item-info h4 {
            font-weight: 500;
            color: #f1f5f9;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            margin-bottom: 0.25rem;
        }

        .cart-item-info span {
            color: #64748b;
            font-size: 0.875rem;
        }

        .cart-item-price {
            font-weight: 600;
            color: var(--success);
        }

        .cart-total {
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            padding-top: 1rem;
            margin-top: 1rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .cart-total .label {
            color: #94a3b8;
        }

        .cart-total .amount {
            font-size: 1.25rem;
            font-weight: 700;
            color: #f1f5f9;
        }

        .btn-checkout {
            display: block;
            width: 100%;
            padding: 1rem;
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            color: white;
            font-weight: 600;
            text-align: center;
            border-radius: 12px;
            text-decoration: none;
            margin-top: 1rem;
            transition: all 0.3s;
        }

        .btn-checkout:hover {
            box-shadow: 0 10px 30px -10px rgba(14, 165, 233, 0.5);
            transform: translateY(-2px);
        }

        /* Quick Actions */
        .quick-action {
            display: flex;
            align-items: center;
            gap: 1rem;
            padding: 0.875rem;
            border-radius: 12px;
            text-decoration: none;
            transition: all 0.2s;
            margin-bottom: 0.5rem;
        }

        .quick-action:last-child {
            margin-bottom: 0;
        }

        .quick-action:hover {
            background: rgba(14, 165, 233, 0.1);
        }

        .quick-action .icon {
            width: 40px;
            height: 40px;
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.2s;
        }

        .quick-action:hover .icon {
            transform: scale(1.1);
        }

        .quick-action .icon.indigo { background: rgba(99, 102, 241, 0.2); color: #818cf8; }
        .quick-action .icon.green { background: rgba(34, 197, 94, 0.2); color: var(--success); }
        .quick-action .icon.purple { background: rgba(168, 85, 247, 0.2); color: #a855f7; }
        .quick-action .icon.blue { background: rgba(14, 165, 233, 0.2); color: var(--primary); }

        .quick-action span {
            font-weight: 500;
            color: #f1f5f9;
        }

        /* Products Grid */
        .products-section {
            margin-top: 2rem;
        }

        .products-header {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 1.5rem;
        }

        .products-header h3 {
            font-size: 1.25rem;
            font-weight: 600;
            color: #f1f5f9;
        }

        .products-header a {
            color: var(--primary);
            text-decoration: none;
            font-weight: 500;
            transition: color 0.2s;
        }

        .products-header a:hover {
            color: #38bdf8;
        }

        .products-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 1.5rem;
        }

        @media (max-width: 1024px) {
            .products-grid { grid-template-columns: repeat(2, 1fr); }
        }

        @media (max-width: 640px) {
            .products-grid { grid-template-columns: 1fr; }
        }

        .product-card {
            background: rgba(30, 41, 59, 0.6);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 16px;
            overflow: hidden;
            transition: all 0.3s;
            text-decoration: none;
        }

        .product-card:hover {
            transform: translateY(-5px);
            border-color: rgba(14, 165, 233, 0.3);
            box-shadow: 0 20px 40px -15px rgba(0, 0, 0, 0.5);
        }

        .product-image {
            aspect-ratio: 1;
            background: rgba(15, 23, 42, 0.8);
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
        }

        .product-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.3s;
        }

        .product-card:hover .product-image img {
            transform: scale(1.05);
        }

        .product-image i {
            font-size: 2.5rem;
            color: #475569;
        }

        .product-content {
            padding: 1.25rem;
        }

        .product-content h4 {
            font-weight: 600;
            color: #f1f5f9;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            margin-bottom: 0.5rem;
            transition: color 0.2s;
        }

        .product-card:hover .product-content h4 {
            color: var(--primary);
        }

        .product-price {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .product-price .current {
            font-size: 1.125rem;
            font-weight: 700;
            color: var(--success);
        }

        .product-price .original {
            color: #64748b;
            text-decoration: line-through;
            font-size: 0.875rem;
        }

        @media (max-width: 640px) {
            .dashboard-content { padding: 1rem; }
            .welcome-banner { padding: 1.5rem; }
            .welcome-banner h1 { font-size: 1.25rem; }
            .order-item { flex-direction: column; align-items: flex-start; gap: 0.75rem; }
            .order-status { width: 100%; justify-content: space-between; }
        }
    </style>

    <div class="dashboard-container">
        <div class="dashboard-content">
            
            <div class="welcome-banner">
                <h1>Welcome back, <span><?php echo e(Auth::user()->name); ?></span>!</h1>
                <p>Here's what's happening with your orders today.</p>
                <a href="<?php echo e(route('shop.home')); ?>" class="btn-shop">
                    <i class="fas fa-shopping-bag"></i>
                    Continue Shopping
                </a>
            </div>

            
            <div class="stats-grid">
                <div class="stat-card">
                    <div class="icon blue">
                        <i class="fas fa-shopping-bag"></i>
                    </div>
                    <div class="label">Total Orders</div>
                    <div class="value"><?php echo e($stats['total_orders']); ?></div>
                </div>
                <div class="stat-card">
                    <div class="icon yellow">
                        <i class="fas fa-clock"></i>
                    </div>
                    <div class="label">Pending Orders</div>
                    <div class="value"><?php echo e($stats['pending_orders']); ?></div>
                </div>
                <div class="stat-card">
                    <div class="icon green">
                        <i class="fas fa-check-circle"></i>
                    </div>
                    <div class="label">Delivered</div>
                    <div class="value"><?php echo e($stats['delivered_orders']); ?></div>
                </div>
                <div class="stat-card">
                    <div class="icon purple">
                        <i class="fas fa-wallet"></i>
                    </div>
                    <div class="label">Total Spent</div>
                    <div class="value">KSh <?php echo e(number_format($stats['total_spent'], 0)); ?></div>
                </div>
            </div>

            
            <div class="main-grid">
                
                <div class="glass-card">
                    <div class="card-header">
                        <h3><i class="fas fa-receipt" style="margin-right: 0.5rem; color: var(--primary);"></i> Recent Orders</h3>
                        <?php if($recentOrders->count() > 0): ?>
                            <a href="#">View All →</a>
                        <?php endif; ?>
                    </div>
                    <div class="card-body">
                        <?php if($recentOrders->count() > 0): ?>
                            <?php $__currentLoopData = $recentOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="order-item">
                                    <div style="display: flex; align-items: center;">
                                        <div class="order-icon">
                                            <i class="fas fa-box"></i>
                                        </div>
                                        <div class="order-info">
                                            <h4><?php echo e($order->order_number); ?></h4>
                                            <span><?php echo e($order->created_at->format('M d, Y')); ?> • <?php echo e($order->items->count()); ?> item(s)</span>
                                        </div>
                                    </div>
                                    <div class="order-status">
                                        <span class="status-badge status-<?php echo e($order->status); ?>">
                                            <?php echo e(ucfirst($order->status)); ?>

                                        </span>
                                        <span class="order-price">KSh <?php echo e(number_format($order->total, 2)); ?></span>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <div class="empty-state">
                                <div class="icon">
                                    <i class="fas fa-shopping-bag"></i>
                                </div>
                                <p>No orders yet. Start shopping to see your orders here!</p>
                                <a href="<?php echo e(route('shop.products')); ?>" class="btn-primary">
                                    <i class="fas fa-shopping-cart"></i>
                                    Start Shopping
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                
                <div>
                    
                    <div class="glass-card" style="margin-bottom: 1.5rem;">
                        <div class="card-header">
                            <h3><i class="fas fa-shopping-cart" style="margin-right: 0.5rem; color: var(--primary);"></i> Your Cart</h3>
                            <?php if($cartItems->count() > 0): ?>
                                <span class="cart-badge"><?php echo e($stats['cart_items']); ?></span>
                            <?php endif; ?>
                        </div>
                        <div class="card-body">
                            <?php if($cartItems->count() > 0): ?>
                                <?php $__currentLoopData = $cartItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="cart-item">
                                        <div class="cart-item-image">
                                            <?php if($item->product->primaryImage): ?>
                                                <img src="<?php echo e(asset('storage/' . $item->product->primaryImage->path)); ?>" alt="<?php echo e($item->product->name); ?>">
                                            <?php else: ?>
                                                <i class="fas fa-image"></i>
                                            <?php endif; ?>
                                        </div>
                                        <div class="cart-item-info">
                                            <h4><?php echo e($item->product->name); ?></h4>
                                            <span>Qty: <?php echo e($item->quantity); ?></span>
                                        </div>
                                        <span class="cart-item-price">KSh <?php echo e(number_format($item->subtotal, 0)); ?></span>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <div class="cart-total">
                                    <span class="label">Subtotal</span>
                                    <span class="amount">KSh <?php echo e(number_format($cartTotal, 2)); ?></span>
                                </div>
                                <a href="<?php echo e(route('cart.index')); ?>" class="btn-checkout">
                                    <i class="fas fa-arrow-right"></i> View Cart & Checkout
                                </a>
                            <?php else: ?>
                                <div class="empty-state" style="padding: 2rem 1rem;">
                                    <div class="icon" style="width: 50px; height: 50px; font-size: 1.25rem;">
                                        <i class="fas fa-shopping-cart"></i>
                                    </div>
                                    <p style="font-size: 0.875rem;">Your cart is empty</p>
                                    <a href="<?php echo e(route('shop.products')); ?>" style="color: var(--primary); font-weight: 500; text-decoration: none;">
                                        Browse Products →
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    
                    <div class="glass-card">
                        <div class="card-header">
                            <h3><i class="fas fa-bolt" style="margin-right: 0.5rem; color: var(--warning);"></i> Quick Actions</h3>
                        </div>
                        <div class="card-body" style="padding: 1rem;">
                            <a href="<?php echo e(route('shop.products')); ?>" class="quick-action">
                                <div class="icon indigo">
                                    <i class="fas fa-box"></i>
                                </div>
                                <span>Browse Products</span>
                            </a>
                            <a href="<?php echo e(route('shop.categories')); ?>" class="quick-action">
                                <div class="icon green">
                                    <i class="fas fa-th-large"></i>
                                </div>
                                <span>View Categories</span>
                            </a>
                            <a href="<?php echo e(route('profile.edit')); ?>" class="quick-action">
                                <div class="icon purple">
                                    <i class="fas fa-user"></i>
                                </div>
                                <span>Edit Profile</span>
                            </a>
                            <a href="<?php echo e(route('shop.contact')); ?>" class="quick-action">
                                <div class="icon blue">
                                    <i class="fas fa-envelope"></i>
                                </div>
                                <span>Contact Support</span>
                            </a>
                        </div>
                    </div>

                    
                    <div class="glass-card" style="margin-top: 1.5rem;">
                        <div class="card-header">
                            <h3><i class="fas fa-address-card" style="margin-right: 0.5rem; color: var(--success);"></i> Contact Info</h3>
                            <a href="<?php echo e(route('profile.edit')); ?>">Edit</a>
                        </div>
                        <div class="card-body" style="padding: 1.25rem;">
                            <div style="display: flex; flex-direction: column; gap: 1rem;">
                                
                                <div style="display: flex; align-items: center; gap: 0.75rem;">
                                    <div style="width: 36px; height: 36px; background: rgba(14, 165, 233, 0.15); border-radius: 8px; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                                        <i class="fas fa-envelope" style="color: var(--primary); font-size: 0.875rem;"></i>
                                    </div>
                                    <div style="min-width: 0;">
                                        <div style="font-size: 0.75rem; color: #64748b;">Email</div>
                                        <div style="font-size: 0.875rem; color: #f1f5f9; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;"><?php echo e(Auth::user()->email); ?></div>
                                    </div>
                                </div>
                                
                                
                                <div style="display: flex; align-items: center; gap: 0.75rem;">
                                    <div style="width: 36px; height: 36px; background: rgba(34, 197, 94, 0.15); border-radius: 8px; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                                        <i class="fas fa-phone" style="color: var(--success); font-size: 0.875rem;"></i>
                                    </div>
                                    <div style="min-width: 0;">
                                        <div style="font-size: 0.75rem; color: #64748b;">Phone</div>
                                        <div style="font-size: 0.875rem; color: #f1f5f9;"><?php echo e(Auth::user()->phone ?? 'Not provided'); ?></div>
                                    </div>
                                </div>
                                
                                
                                <div style="display: flex; align-items: flex-start; gap: 0.75rem;">
                                    <div style="width: 36px; height: 36px; background: rgba(168, 85, 247, 0.15); border-radius: 8px; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                                        <i class="fas fa-map-marker-alt" style="color: #a855f7; font-size: 0.875rem;"></i>
                                    </div>
                                    <div style="min-width: 0;">
                                        <div style="font-size: 0.75rem; color: #64748b;">Address</div>
                                        <div style="font-size: 0.875rem; color: #f1f5f9; line-height: 1.4;">
                                            <?php if(Auth::user()->address || Auth::user()->city || Auth::user()->county): ?>
                                                <?php if(Auth::user()->address): ?><?php echo e(Auth::user()->address); ?><br><?php endif; ?>
                                                <?php if(Auth::user()->city || Auth::user()->county): ?>
                                                    <?php echo e(Auth::user()->city); ?><?php echo e(Auth::user()->city && Auth::user()->county ? ', ' : ''); ?><?php echo e(Auth::user()->county); ?>

                                                <?php endif; ?>
                                            <?php else: ?>
                                                <span style="color: #64748b;">Not provided</span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <?php if(!Auth::user()->phone && !Auth::user()->address): ?>
                                <div style="margin-top: 1rem; padding: 0.75rem; background: rgba(245, 158, 11, 0.1); border: 1px solid rgba(245, 158, 11, 0.2); border-radius: 8px;">
                                    <p style="font-size: 0.8125rem; color: var(--warning); margin: 0;">
                                        <i class="fas fa-info-circle" style="margin-right: 0.25rem;"></i>
                                        Complete your profile for faster checkout
                                    </p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            
            <?php if($recommendedProducts->count() > 0): ?>
                <div class="products-section">
                    <div class="products-header">
                        <h3><i class="fas fa-star" style="margin-right: 0.5rem; color: var(--warning);"></i> Recommended For You</h3>
                        <a href="<?php echo e(route('shop.products')); ?>">View All →</a>
                    </div>
                    <div class="products-grid">
                        <?php $__currentLoopData = $recommendedProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('shop.product', $product)); ?>" class="product-card">
                                <div class="product-image">
                                    <?php if($product->primaryImage): ?>
                                        <img src="<?php echo e(asset('storage/' . $product->primaryImage->path)); ?>" alt="<?php echo e($product->name); ?>">
                                    <?php else: ?>
                                        <i class="fas fa-box"></i>
                                    <?php endif; ?>
                                </div>
                                <div class="product-content">
                                    <h4><?php echo e($product->name); ?></h4>
                                    <div class="product-price">
                                        <span class="current">KSh <?php echo e(number_format($product->effective_price, 0)); ?></span>
                                        <?php if($product->sale_price && $product->sale_price < $product->price): ?>
                                            <span class="original">KSh <?php echo e(number_format($product->price, 0)); ?></span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\xampp\htdocs\shop\resources\views/dashboard.blade.php ENDPATH**/ ?>