

<?php $__env->startSection('title', 'Order ' . $order->order_number); ?>

<?php $__env->startSection('content'); ?>
<div class="flex justify-between items-center mb-3">
    <a href="<?php echo e(route('admin.orders.index')); ?>" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Back to Orders
    </a>
    <div class="flex gap-2">
        <a href="<?php echo e($customerLink); ?>" target="_blank" class="btn" style="background: #25D366; color: white;">
            <i class="fab fa-whatsapp"></i> Send Invoice to Customer
        </a>
    </div>
</div>

<div class="grid grid-2">
    <!-- Order Info -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Order Details</h3>
            <span class="badge badge-<?php echo e($order->status_badge['color']); ?>" style="font-size: 0.9rem;">
                <?php echo e($order->status_badge['label']); ?>

            </span>
        </div>

        <div class="grid grid-2">
            <div>
                <div class="text-muted" style="font-size: 0.8rem;">Order Number</div>
                <strong><?php echo e($order->order_number); ?></strong>
            </div>
            <div>
                <div class="text-muted" style="font-size: 0.8rem;">Date</div>
                <strong><?php echo e($order->created_at->format('M d, Y h:i A')); ?></strong>
            </div>
        </div>

        <hr style="border-color: rgba(255,255,255,0.1); margin: 1rem 0;">

        <!-- Update Status -->
        <form method="POST" action="<?php echo e(route('admin.orders.update-status', $order)); ?>" class="mb-3">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PATCH'); ?>
            <div class="flex gap-2 items-center">
                <select name="status" class="form-select" style="flex: 1;">
                    <option value="pending" <?php echo e($order->status == 'pending' ? 'selected' : ''); ?>>Pending</option>
                    <option value="processing" <?php echo e($order->status == 'processing' ? 'selected' : ''); ?>>Processing</option>
                    <option value="confirmed" <?php echo e($order->status == 'confirmed' ? 'selected' : ''); ?>>Confirmed</option>
                    <option value="shipped" <?php echo e($order->status == 'shipped' ? 'selected' : ''); ?>>Shipped</option>
                    <option value="delivered" <?php echo e($order->status == 'delivered' ? 'selected' : ''); ?>>Delivered</option>
                    <option value="cancelled" <?php echo e($order->status == 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
                </select>
                <button type="submit" class="btn btn-primary btn-sm">Update Status</button>
            </div>
        </form>

        <!-- Update Payment Status -->
        <form method="POST" action="<?php echo e(route('admin.orders.update-payment-status', $order)); ?>">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PATCH'); ?>
            <div class="flex gap-2 items-center">
                <select name="payment_status" class="form-select" style="flex: 1;">
                    <option value="pending" <?php echo e($order->payment_status == 'pending' ? 'selected' : ''); ?>>Pending</option>
                    <option value="paid" <?php echo e($order->payment_status == 'paid' ? 'selected' : ''); ?>>Paid</option>
                    <option value="failed" <?php echo e($order->payment_status == 'failed' ? 'selected' : ''); ?>>Failed</option>
                    <option value="refunded" <?php echo e($order->payment_status == 'refunded' ? 'selected' : ''); ?>>Refunded</option>
                </select>
                <button type="submit" class="btn btn-primary btn-sm">Update Payment</button>
            </div>
        </form>
    </div>

    <!-- Customer Info -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Customer Information</h3>
        </div>

        <div class="mb-2">
            <div class="text-muted" style="font-size: 0.8rem;">Name</div>
            <strong><?php echo e($order->customer_name); ?></strong>
        </div>

        <div class="mb-2">
            <div class="text-muted" style="font-size: 0.8rem;">Email</div>
            <a href="mailto:<?php echo e($order->customer_email); ?>" class="text-primary"><?php echo e($order->customer_email); ?></a>
        </div>

        <div class="mb-2">
            <div class="text-muted" style="font-size: 0.8rem;">Phone</div>
            <a href="tel:<?php echo e($order->customer_phone); ?>" class="text-primary"><?php echo e($order->customer_phone); ?></a>
        </div>

        <?php if($order->shipping_address): ?>
        <div class="mb-2">
            <div class="text-muted" style="font-size: 0.8rem;">Shipping Address</div>
            <div><?php echo e($order->shipping_address); ?></div>
            <?php if($order->city || $order->county): ?>
                <div><?php echo e($order->city); ?><?php echo e($order->county ? ', ' . $order->county : ''); ?></div>
            <?php endif; ?>
        </div>
        <?php endif; ?>

        <?php if($order->notes): ?>
        <div>
            <div class="text-muted" style="font-size: 0.8rem;">Order Notes</div>
            <div><?php echo e($order->notes); ?></div>
        </div>
        <?php endif; ?>
    </div>
</div>

<!-- Order Items -->
<div class="card">
    <div class="card-header">
        <h3 class="card-title">Order Items</h3>
    </div>

    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th>Product</th>
                    <th>SKU</th>
                    <th>Price</th>
                    <th>Quantity</th>
                    <th>Subtotal</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td>
                        <strong><?php echo e($item->product_name); ?></strong>
                        <?php if($item->includes_installation): ?>
                            <div class="badge badge-info" style="margin-top: 4px;">+ Installation</div>
                        <?php endif; ?>
                    </td>
                    <td><?php echo e($item->product_sku); ?></td>
                    <td>KSh <?php echo e(number_format($item->price, 2)); ?></td>
                    <td><?php echo e($item->quantity); ?></td>
                    <td>
                        <strong>KSh <?php echo e(number_format($item->subtotal, 2)); ?></strong>
                        <?php if($item->includes_installation): ?>
                            <div class="text-muted" style="font-size: 0.8rem;">
                                + KSh <?php echo e(number_format($item->installation_price * $item->quantity, 2)); ?> installation
                            </div>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

    <!-- Totals -->
    <div style="margin-top: 1.5rem; padding-top: 1rem; border-top: 1px solid rgba(255,255,255,0.1);">
        <div class="flex justify-between mb-1">
            <span>Subtotal</span>
            <span>KSh <?php echo e(number_format($order->subtotal, 2)); ?></span>
        </div>
        <?php if($order->shipping_cost > 0): ?>
        <div class="flex justify-between mb-1">
            <span>Shipping</span>
            <span>KSh <?php echo e(number_format($order->shipping_cost, 2)); ?></span>
        </div>
        <?php endif; ?>
        <?php if($order->installation_cost > 0): ?>
        <div class="flex justify-between mb-1">
            <span>Installation</span>
            <span>KSh <?php echo e(number_format($order->installation_cost, 2)); ?></span>
        </div>
        <?php endif; ?>
        <?php if($order->installation_discount > 0): ?>
        <div class="flex justify-between mb-1 text-success">
            <span>Installation Discount (Shop Customer)</span>
            <span>- KSh <?php echo e(number_format($order->installation_discount, 2)); ?></span>
        </div>
        <?php endif; ?>
        <?php if($order->discount > 0): ?>
        <div class="flex justify-between mb-1 text-success">
            <span>Discount</span>
            <span>- KSh <?php echo e(number_format($order->discount, 2)); ?></span>
        </div>
        <?php endif; ?>
        <div class="flex justify-between" style="font-size: 1.25rem; font-weight: 700; margin-top: 0.5rem; padding-top: 0.5rem; border-top: 1px solid rgba(255,255,255,0.1);">
            <span>Total</span>
            <span>KSh <?php echo e(number_format($order->total, 2)); ?></span>
        </div>
    </div>
</div>

<!-- Payment History -->
<?php if($order->payments->count() > 0): ?>
<div class="card">
    <div class="card-header">
        <h3 class="card-title">Payment History</h3>
    </div>

    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th>Method</th>
                    <th>Transaction ID</th>
                    <th>Amount</th>
                    <th>Status</th>
                    <th>Date</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $order->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e(strtoupper($payment->payment_method)); ?></td>
                    <td><?php echo e($payment->transaction_id ?? '-'); ?></td>
                    <td>KSh <?php echo e(number_format($payment->amount, 2)); ?></td>
                    <td>
                        <span class="badge badge-<?php echo e($payment->status_badge['color']); ?>">
                            <?php echo e($payment->status_badge['label']); ?>

                        </span>
                    </td>
                    <td><?php echo e($payment->created_at->format('M d, Y h:i A')); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\shop\resources\views/admin/orders/show.blade.php ENDPATH**/ ?>