<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Invoice - <?php echo e($order->order_number); ?></title>
    <style>
        body {
            font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif;
            font-size: 14px;
            line-height: 1.6;
            color: #333;
        }
        .invoice-box {
            max-width: 800px;
            margin: auto;
            padding: 30px;
            border: 1px solid #eee;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.15);
        }
        .header {
            margin-bottom: 40px;
        }
        .header td {
            vertical-align: top;
        }
        .company-details {
            text-align: right;
        }
        .company-name {
            font-size: 24px;
            font-weight: bold;
            color: #0ea5e9;
            margin-bottom: 5px;
        }
        .invoice-details {
            margin-bottom: 30px;
        }
        .invoice-details table {
            width: 100%;
        }
        .billing-details {
            margin-bottom: 30px;
        }
        table {
            width: 100%;
            line-height: inherit;
            text-align: left;
            border-collapse: collapse;
        }
        
        /* Items Table */
        .items-table th {
            background: #f8fafc;
            border-bottom: 1px solid #e2e8f0;
            font-weight: bold;
            padding: 12px;
            text-align: left;
        }
        .items-table td {
            border-bottom: 1px solid #eee;
            padding: 12px;
        }
        .items-table tr:last-child td {
            border-bottom: none;
        }
        
        /* Totals */
        .totals-table {
            margin-top: 20px;
            width: 300px;
            float: right;
        }
        .totals-table td {
            padding: 5px;
            text-align: right;
        }
        .totals-table .total-row td {
            font-weight: bold;
            border-top: 2px solid #333;
            padding-top: 10px;
        }
        
        .footer {
            margin-top: 50px;
            padding-top: 20px;
            border-top: 1px solid #eee;
            text-align: center;
            font-size: 12px;
            color: #777;
            clear: both;
        }
        .status-badge {
            display: inline-block;
            padding: 5px 10px;
            border-radius: 4px;
            font-size: 12px;
            font-weight: bold;
            text-transform: uppercase;
        }
        .status-paid { background: #dcfce7; color: #166534; }
        .status-pending { background: #fef9c3; color: #854d0e; }
    </style>
</head>
<body>
    <div class="invoice-box">
        <table class="header">
            <tr>
                <td>
                    <h1 style="margin: 0;">INVOICE</h1>
                    <p style="margin: 5px 0;">#<?php echo e($order->order_number); ?></p>
                    <p style="margin: 5px 0;">Date: <?php echo e($order->created_at->format('M d, Y')); ?></p>
                    <div style="margin-top: 10px;">
                        Payment Status: 
                        <span class="status-badge status-<?php echo e($order->payment_status); ?>">
                            <?php echo e(ucfirst($order->payment_status)); ?>

                        </span>
                    </div>
                </td>
                <td class="company-details">
                    <div class="company-name"><?php echo e($company['name']); ?></div>
                    <div><?php echo e($company['address']); ?></div>
                    <div><?php echo e($company['phone']); ?></div>
                    <div><?php echo e($company['email']); ?></div>
                    <div><?php echo e($company['website']); ?></div>
                </td>
            </tr>
        </table>

        <div class="billing-details">
            <strong>Bill To:</strong><br>
            <?php echo e($order->customer_name); ?><br>
            <?php echo e($order->customer_email); ?><br>
            <?php echo e($order->customer_phone); ?><br>
            <?php if($order->shipping_address): ?>
                <?php echo e($order->shipping_address); ?><br>
                <?php echo e($order->city); ?>, <?php echo e($order->county); ?>

            <?php endif; ?>
        </div>

        <table class="items-table">
            <thead>
                <tr>
                    <th>Item</th>
                    <th style="text-align: center;">Qty</th>
                    <th style="text-align: right;">Price</th>
                    <th style="text-align: right;">Total</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <strong><?php echo e($item->product_name); ?></strong>
                            <?php if($item->includes_installation): ?>
                                <br><small class="text-muted">+ Installation included</small>
                            <?php endif; ?>
                        </td>
                        <td style="text-align: center;"><?php echo e($item->quantity); ?></td>
                        <td style="text-align: right;"><?php echo e(number_format($item->price, 2)); ?></td>
                        <td style="text-align: right;"><?php echo e(number_format($item->total, 2)); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <table class="totals-table">
            <tr>
                <td>Subtotal:</td>
                <td><?php echo e(number_format($order->subtotal, 2)); ?></td>
            </tr>
            <?php if($order->installation_cost > 0): ?>
                <tr>
                    <td>Installation:</td>
                    <td><?php echo e(number_format($order->installation_cost, 2)); ?></td>
                </tr>
            <?php endif; ?>
            <?php if($order->shipping_cost > 0): ?>
                <tr>
                    <td>Shipping:</td>
                    <td><?php echo e(number_format($order->shipping_cost, 2)); ?></td>
                </tr>
            <?php endif; ?>
            <?php if($order->discount > 0): ?>
                <tr>
                    <td>Discount:</td>
                    <td>-<?php echo e(number_format($order->discount, 2)); ?></td>
                </tr>
            <?php endif; ?>
            <tr class="total-row">
                <td>Total (KSh):</td>
                <td><?php echo e(number_format($order->total, 2)); ?></td>
            </tr>
        </table>

        <div class="footer">
            <p>Thank you for your business!</p>
            <p>Terms & Conditions Apply</p>
        </div>
    </div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\shop\resources\views/invoices/order.blade.php ENDPATH**/ ?>